<?php
require __DIR__ . '/../../vendor/autoload.php';
$app = require_once __DIR__ . '/../../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Services\GoogleAnalyticsService;
use Carbon\Carbon;

$svc = app(GoogleAnalyticsService::class);
$to = Carbon::now();
$from = Carbon::now()->subDays(29);

$out = $svc->getTopPages($from, $to, 10);
echo json_encode($out, JSON_PRETTY_PRINT) . "\n";
