<?php
require __DIR__ . '/../../vendor/autoload.php';
$app = require_once __DIR__ . '/../../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Services\GoogleAnalyticsService;
use Carbon\Carbon;

$svc = app(GoogleAnalyticsService::class);
$ranges = [
    '7_days' => [Carbon::now()->subDays(7), Carbon::now()],
    '30_days' => [Carbon::now()->subDays(30), Carbon::now()],
    '365_days' => [Carbon::now()->subDays(365), Carbon::now()],
];
$out = [];
foreach ($ranges as $k => [$from, $to]) {
    $total = $svc->getTotalUsers($from, $to);
    $out[$k] = ['from' => $from->toDateString(), 'to' => $to->toDateString(), 'total' => $total];
}
echo json_encode($out, JSON_PRETTY_PRINT) . "\n";
