<?php
require __DIR__ . '/../../vendor/autoload.php';
$app = require_once __DIR__ . '/../../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Services\GoogleAnalyticsService;
use Carbon\Carbon;

$svc = app(GoogleAnalyticsService::class);
$to = Carbon::now();
$from = Carbon::now()->subDays(30);

$out = [];
$out['pageviews_30_days'] = $svc->getPageViews($from, $to);
$out['realtime_pageviews'] = $svc->getRealtimePageViews();

echo json_encode($out, JSON_PRETTY_PRINT) . "\n";
