<?php if($seo): ?>
    <meta name="title" content="<?php echo e($pageTitle ?? $general->siteName(__($pageTitle))); ?>">
    <meta name="description" content="<?php echo e($seo->description); ?>">
    <meta name="keywords" content="<?php echo e(implode(',',$seo->keywords)); ?>">
    <link rel="shortcut icon" href="<?php echo e(getImage(getFilePath('logoIcon') .'/favicon.png')); ?>" type="image/x-icon">

    <meta name="author" content="<?php echo e(config('app.name')); ?>">

    
    <link rel="apple-touch-icon" href="<?php echo e(getImage(getFilePath('logoIcon') .'/favicon.png')); ?>">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="<?php echo e($general->siteName($pageTitle)); ?>">
    
    <meta itemprop="name" content="<?php echo e($general->siteName($pageTitle)); ?>">
    <meta itemprop="description" content="<?php echo e($pageDescription ?? $general->seo_description); ?>">
    <meta itemprop="image" content="<?php echo e($pageImage ?? getImage(getFilePath('seo') .'/'. $seo->image)); ?>">
    
    <meta property="og:type" content="article">
    <meta property="og:title" content="<?php echo e($general->siteName($pageTitle)); ?>">
    <meta property="og:description" content="<?php echo e($pageDescription ?? $seo->social_description); ?>">
    <meta property="og:image" content="<?php echo e($pageImage ?? getImage(getFilePath('seo') .'/'. $seo->image)); ?>">
    <meta property="og:image:type" content="image/<?php echo e(pathinfo($pageImage ?? getImage(getFilePath('seo')) .'/'. $seo->image)['extension']); ?>">
    <?php $socialImageSize = explode('x', getFileSize('seo')) ?>
    <meta property="og:image:width" content="<?php echo e($socialImageSize[0]); ?>">
    <meta property="og:image:height" content="<?php echo e($socialImageSize[1]); ?>">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo e($general->siteName($pageTitle)); ?>">
    <meta name="twitter:description" content="<?php echo e($pageDescription ?? $seo->social_description); ?>">
    <meta name="twitter:image" content="<?php echo e($pageImage ?? getImage(getFilePath('seo') .'/'. $seo->image)); ?>">
<?php endif; ?>
<?php /**PATH /Users/phokpisethsambo/prestige-website/application/resources/views/includes/seo.blade.php ENDPATH**/ ?>