<?php
    $team = getContent('team_member.content', true);
    $teamElements = getContent('team_member.element', false);
?>

<!-- ==================== Team Start Here ==================== -->
<section class="team-area pb-80">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <h3 class="text-center fw-bold text-base"><?php echo e(__($team->data_values->heading)); ?></h3>
            </div>
        </div>

        <div class="row gy-4 mt-3 teammember-wrapper">
            <?php $__currentLoopData = $teamElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6 col-12 teammember-item">
                    <div class="team-card h-100">
                        <div class="team-card-inner">
                            <div class="team-photo-wrapper">
                                <img src="<?php echo e(getImage(getFilePath('teamMember') . '/' . $item->data_values->agent_image)); ?>"
                                    class="team-photo"
                                    alt="<?php echo e(__($item->data_values->title)); ?>" loading="lazy">
                            </div>

                            <div class="team-content" data-bs-toggle="modal" data-bs-target="#teamModal<?php echo e($index); ?>">
                                <h5 class="team-name"><?php echo e(__($item->data_values->title)); ?></h5>
                                <p class="team-position"><?php echo e(__($item->data_values->designation)); ?></p>
                                <p class="team-description">
                                    <?php echo e(Str::limit(__($item->data_values->description), 120)); ?>

                                    <?php if(strlen(__($item->data_values->description)) > 120): ?>
                                        <a href="#" class="see-more-link" data-bs-toggle="modal" data-bs-target="#teamModal<?php echo e($index); ?>">
                                            See More
                                        </a>
                                    <?php endif; ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Modal for each team member -->
                <div class="modal fade" id="teamModal<?php echo e($index); ?>" tabindex="-1" aria-labelledby="teamModalLabel<?php echo e($index); ?>" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-xl">
                        <div class="modal-content">
                            <div class="modal-header border-0">
                                <h5 class="modal-title fw-bold text-base" id="teamModalLabel<?php echo e($index); ?>">
                                    Team Member Details
                                </h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <div class="row g-4">
                                    <div class="col-md-4">
                                        <img src="<?php echo e(getImage(getFilePath('teamMember') . '/' . $item->data_values->agent_image)); ?>"
                                            class="img-fluid rounded shadow-sm"
                                            alt="<?php echo e(__($item->data_values->title)); ?>" loading="lazy">
                                    </div>
                                    <div class="col-md-8">
                                        <h4 class="fw-bold text-base mb-2"><?php echo e(__($item->data_values->title)); ?></h4>
                                        <p class="text-muted mb-3">
                                            <i class="fas fa-briefcase me-2"></i><?php echo e(__($item->data_values->designation)); ?>

                                        </p>

                                        <div class="mb-3">
                                            <h6 class="fw-bold mb-2">About</h6>
                                            <p class="modal-description">
                                                <?php echo e(__($item->data_values->description)); ?>

                                            </p>
                                        </div>

                                        <?php if(!empty($item->data_values->email)): ?>
                                        <div class="mb-2">
                                            <i class="fas fa-envelope me-2 text-primary"></i>
                                            <a href="mailto:<?php echo e($item->data_values->email); ?>" class="text-decoration-none">
                                                <?php echo e($item->data_values->email); ?>

                                            </a>
                                        </div>
                                        <?php endif; ?>

                                        <?php if(!empty($item->data_values->phone)): ?>
                                        <div class="mb-2">
                                            <i class="fas fa-phone me-2 text-primary"></i>
                                            <a href="tel:<?php echo e($item->data_values->phone); ?>" class="text-decoration-none">
                                                <?php echo e($item->data_values->phone); ?>

                                            </a>
                                        </div>
                                        <?php endif; ?>

                                        <?php if(!empty($item->data_values->social_links)): ?>
                                        <div class="mt-3">
                                            <h6 class="fw-bold mb-2">Connect</h6>
                                            <div class="social-links">
                                                <?php if(!empty($item->data_values->social_links->linkedin)): ?>
                                                <a href="<?php echo e($item->data_values->social_links->linkedin); ?>" target="_blank"
                                                   class="btn btn-sm btn-outline-primary me-2">
                                                    <i class="fab fa-linkedin-in"></i>
                                                </a>
                                                <?php endif; ?>
                                                <?php if(!empty($item->data_values->social_links->twitter)): ?>
                                                <a href="<?php echo e($item->data_values->social_links->twitter); ?>" target="_blank"
                                                   class="btn btn-sm btn-outline-primary me-2">
                                                    <i class="fab fa-twitter"></i>
                                                </a>
                                                <?php endif; ?>
                                                <?php if(!empty($item->data_values->social_links->facebook)): ?>
                                                <a href="<?php echo e($item->data_values->social_links->facebook); ?>" target="_blank"
                                                   class="btn btn-sm btn-outline-primary me-2">
                                                    <i class="fab fa-facebook-f"></i>
                                                </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer border-0">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<!-- ==================== Team End Here ==================== -->

<script>
// Smooth scroll prevention when modal opens
document.addEventListener('DOMContentLoaded', function() {
    const modals = document.querySelectorAll('.modal');

    modals.forEach(modal => {
        modal.addEventListener('show.bs.modal', function() {
            document.body.style.overflow = 'hidden';
        });

        modal.addEventListener('hide.bs.modal', function() {
            document.body.style.overflow = 'auto';
        });
    });
});
</script>
<?php /**PATH /Users/phokpisethsambo/prestige-website/application/resources/views/presets/default/sections/new/team_member.blade.php ENDPATH**/ ?>