<!doctype html>
<html lang="<?php echo e(config('app.locale')); ?>" itemscope itemtype="http://schema.org/WebPage">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo e($general->siteName(__($pageTitle))); ?></title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="48x48" href="<?php echo e(asset('assets/images/general/favicon.png')); ?>">
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/general/favicon.png')); ?>" type="image/x-icon">
    <link rel="apple-touch-icon" href="<?php echo e(asset('assets/images/general/favicon.png')); ?>">

    <script type="application/ld+json">
    {
    "@context": "https://schema.org",
    "@type": "Organization",
    "url": "<?php echo e(url('/')); ?>",
    "logo": "<?php echo e(asset('assets/images/general/favicon.png')); ?>"
    }
    </script>

    <?php echo $__env->make('includes.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <link href="https://fonts.cdnfonts.com/css/helvetica-neue-55" rel="stylesheet">

    <style>
        @font-face {
            font-family: Helvetica;
            src: url('<?php echo e(asset('/assets/font/Helvetica.ttf')); ?>');
            font-style: normal;
            font-weight: normal;
        }
        @font-face {
            font-family: Helvetica;
            src: url('<?php echo e(asset('/assets/font/Helvetica-Bold.ttf')); ?>');
            font-style: normal;
            font-weight: bold;
        }
    </style>
    <!-- Bootstrap CSS -->
    <link href="<?php echo e(asset('assets/common/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/common/css/all.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/common/css/line-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/common/css/swiper-bundle.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/magnific-popup.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/custom-animation.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/odometer.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/main.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/prestige.css')); ?>?v=<?php echo e(time()); ?>">

    <?php echo $__env->yieldPushContent('style-lib'); ?>

    <?php echo $__env->yieldPushContent('style'); ?>

    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/color.php')); ?>?color=<?php echo e($general->base_color); ?>&secondColor=<?php echo e($general->secondary_color); ?>">
    <?php echo $__env->make('partials.analytics', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body>

<!--==================== Preloader Start ====================-->
<div id="loading">
    <div id="loading-center">
        <div id="loading-center-absolute">
            <img id="object-image" src="<?php echo e(asset('assets/images/general/favicon.png')); ?>" style="height: 50px;">
            <!-- <div class="object" id="object_one"></div>
            <div class="object" id="object_two"></div>
            <div class="object" id="object_three"></div> -->
        </div>
    </div>
</div>
 <!--==================== Preloader End ====================-->
<!--==================== Overlay Start ====================-->
<div class="body-overlay"></div>
<!--==================== Overlay End ====================-->

<!--==================== Sidebar Overlay End ====================-->
<div class="sidebar-overlay"></div>
<!--==================== Sidebar Overlay End ====================-->

<!-- ==================== Scroll to Top End Here ==================== -->
<a class="scroll-top"><i class="fas fa-angle-double-up"></i></a>
<!-- ==================== Scroll to Top End Here ==================== -->

<div id="main-header">
<?php echo $__env->make($activeTemplate.'components.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</div>

<?php if(request()->route()->uri != '/'): ?>
 <?php echo $__env->make($activeTemplate.'components.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
 <?php endif; ?>

<?php echo $__env->yieldContent('content'); ?>

<?php echo $__env->make($activeTemplate.'components.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php
    $cookie = App\Models\Frontend::where('data_keys','cookie.data')->first();
?>
<?php if(($cookie->data_values->status == 1) && !\Cookie::get('gdpr_cookie')): ?>
    <!-- cookies dark version start -->
    <div class="cookies-card text-center hide">
      <p class="mt-4 cookies-card__content"><?php echo e($cookie->data_values->short_desc); ?> <a href="<?php echo e(route('cookie.policy')); ?>" target="_blank"><?php echo app('translator')->get('learn more'); ?></a></p>
      <div class="cookies-card__btn mt-4">
        <a href="javascript:void(0)" class="btn btn--base w-50 policy"><?php echo app('translator')->get('Allow'); ?></a>
      </div>
    </div>
  <!-- cookies dark version end -->
  <?php endif; ?>


<!-- Optional JavaScript -->
<!-- jQuery first, then Popper.js, then Bootstrap JS -->
<script src="<?php echo e(asset('assets/common/js/jquery-3.7.0.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/common/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset($activeTemplateTrue.'js/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset($activeTemplateTrue.'js/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/common/js/swiper-bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset($activeTemplateTrue.'js/slick.min.js')); ?>"></script>
<script src="<?php echo e(asset($activeTemplateTrue.'js/moment.min.js')); ?>"></script>
<script src="<?php echo e(asset($activeTemplateTrue.'js/jquery.appear.min.js')); ?>"></script>
<script src="<?php echo e(asset($activeTemplateTrue.'js/jquery.magnific-popup.min.js')); ?>"></script>
<script src="<?php echo e(asset($activeTemplateTrue.'js/odometer.min.js')); ?>"></script>
<script src="<?php echo e(asset($activeTemplateTrue.'js/viewport.jquery.js')); ?>"></script>
<script src="<?php echo e(asset($activeTemplateTrue.'js/main.js')); ?>"></script>
<script src="<?php echo e(asset($activeTemplateTrue.'js/custom.js')); ?>?v=<?php echo e(time()); ?>"></script>

<?php echo $__env->yieldPushContent('script-lib'); ?>

<?php echo $__env->yieldPushContent('script'); ?>

<?php echo $__env->make('includes.plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('includes.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<script>
    (function ($) {
        "use strict";
        $(".langSel").on("change", function() {
            window.location.href = "<?php echo e(route('home')); ?>/change/"+$(this).val() ;
        });

        var inputElements = $('input,select');
        $.each(inputElements, function (index, element) {
            element = $(element);
            element.closest('.form-group').find('label').attr('for',element.attr('name'));
            element.attr('id',element.attr('name'))
        });

        $('.policy').on('click',function(){
            $.get('<?php echo e(route('cookie.accept')); ?>', function(response){
                $('.cookies-card').addClass('d-none');
            });
        });

        setTimeout(function(){
            $('.cookies-card').removeClass('hide')
        },2000);

        var inputElements = $('[type=text],select,textarea');
        $.each(inputElements, function (index, element) {
            element = $(element);
            element.closest('.form-group').find('label').attr('for',element.attr('name'));
            element.attr('id',element.attr('name'))
        });

        $.each($('input, select, textarea'), function (i, element) {

            if (element.hasAttribute('required')) {
                $(element).closest('.form-group').find('label').addClass('required');
            }

        });

    })(jQuery);
</script>

</body>
</html>
<?php /**PATH /Users/phokpisethsambo/prestige-website/application/resources/views/presets/default/layouts/frontend.blade.php ENDPATH**/ ?>