<?php $__env->startSection('panel'); ?>
<div class="card">
    <div class="card-body">
        <!-- ======================= SEARCH UI ======================= -->
        <div class="d-flex justify-content-between align-items-center mb-4">

            <form method="GET"
                  action="<?php echo e(route('admin.reportdownloads.index')); ?>"
                  class="search-form d-flex align-items-center"
                  style="width: 350px;">

                <div class="input-group">
                    <input type="text"
                           name="search"
                           id="searchInput"
                           class="form-control"
                           placeholder="Search Options..."
                           value="<?php echo e(request('search')); ?>">

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i>
                    </button>
                </div>

            </form>

        </div>
        <!-- ======================= END SEARCH UI ======================= -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <span class="total-badge">
                Total Downloads: <strong><?php echo e($totalDownloads); ?></strong>
            </span>
        </div>

        <!-- ======================= TABLE ======================= -->
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th width="60">ID</th>
                        <th>Report</th>
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th>Email</th>
                        <th width="200">Download Link</th>
                        <th width="180">Downloaded At</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $downloads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $download): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><span class="id-badge"><?php echo e($loop->iteration + ($downloads->currentPage()-1) * $downloads->perPage()); ?></span></td>

                        <td><?php echo e(optional($download->report)->title ?? '-'); ?></td>

                        <td><strong><?php echo e($download->first_name); ?></strong></td>

                        <td><strong><?php echo e($download->last_name); ?></strong></td>

                        <td class="email-cell"><?php echo e($download->email); ?></td>

                        <td>
                            <?php
                                // Prefer the snapshot fields stored on the download row.
                                $file = $download->download_report_file ?? optional($download->report)->download_report_file;
                                $external = $download->download_report_external_url ?? optional($download->report)->download_report_external_url;
                            ?>

                            <?php if($external && $file): ?>
                                <a href="<?php echo e($external); ?>"
                                   target="_blank"
                                   class="btn btn-sm btn-info">
                                    <i class="fas fa-external-link-alt"></i> External Link
                                </a>
                                <a href="<?php echo e(asset(getFilePath('reportInsideImage').'/'.$file)); ?>"
                                   target="_blank"
                                   class="btn btn-sm btn-primary ml-2">
                                    <i class="fas fa-file-pdf"></i> View PDF
                                </a>
                            <?php elseif($external): ?>
                                <a href="<?php echo e($external); ?>"
                                   target="_blank"
                                   class="btn btn-sm btn-info">
                                    <i class="fas fa-external-link-alt"></i> External Link
                                </a>
                            <?php elseif($file): ?>
                                <a href="<?php echo e(asset(getFilePath('reportInsideImage').'/'.$file)); ?>"
                                   target="_blank"
                                   class="btn btn-sm btn-primary">
                                    <i class="fas fa-file-pdf"></i> View PDF
                                </a>
                            <?php elseif($download->report): ?>
                                <span class="text-muted">No file</span>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>

                        <td class="date-cell"><?php echo e(showDateTime($download->created_at)); ?></td>
                    </tr>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center py-5 text-muted">
                            <i class="fas fa-folder-open fa-2x mb-2"></i><br>
                            No downloads found.
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>

            </table>
        </div>

        <!-- ======================= PAGINATION ======================= -->
        <div class="mt-3">
            <?php echo e($downloads->links()); ?>

        </div>

    </div>
</div>

<!-- ======================= AUTO RESET SEARCH WHEN EMPTY ======================= -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    const searchInput = document.getElementById("searchInput");

    if (!searchInput) return;

    searchInput.addEventListener("input", function () {
        if (this.value.trim() === "") {
            window.location = "<?php echo e(route('admin.reportdownloads.index')); ?>";
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/phokpisethsambo/prestige-website/application/resources/views/admin/reportdownloads/index.blade.php ENDPATH**/ ?>