<?php $__env->startSection('panel'); ?>

<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-header fw-bold">
                <?php echo app('translator')->get('Office Space Rate'); ?>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Type'); ?></th>
                                <th><?php echo app('translator')->get('Room'); ?></th>
                                <th><?php echo app('translator')->get('Floor'); ?></th>
                                <th><?php echo app('translator')->get('Size (m)'); ?></th>
                                <th><?php echo app('translator')->get('Additional Space'); ?></th>
                                <th><?php echo app('translator')->get('Amenities'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $officeSpaces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $office): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($office->type); ?></td>
                                <td><?php echo e($office->room); ?></td>
                                <td><?php echo e($office->floor); ?></td>
                                <td><?php echo e($office->size); ?></td>
                                <td><?php echo e($office->additional_space); ?></td>
                                <td><?php echo e($office->amenities); ?></td>
                                <td>
                                    <?php
                                        echo $office->statusBadge($office->status);
                                    ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.officeandeventspace.edit',$office->id)); ?>" title="<?php echo app('translator')->get('Edit'); ?>" class="btn btn-sm btn--primary updateService ">
                                        <i class="las la-edit"></i>
                                    </a>
                                    <button title="<?php echo app('translator')->get('Remove'); ?>"
                                     data-id="<?php echo e($office->id); ?>"
                                        class="btn btn-sm btn--danger rejectBtn">
                                        <i class="las la-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                            <?php endif; ?>

                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
        </div><!-- card end -->
    </div>
</div>

<hr class="mt-5">

<div class="row mt-5">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-header fw-bold">
                <?php echo app('translator')->get('Event Space Rate'); ?>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Type'); ?></th>
                                <th><?php echo app('translator')->get('Room'); ?></th>
                                <th><?php echo app('translator')->get('Floor'); ?></th>
                                <th><?php echo app('translator')->get('Size (m)'); ?></th>
                                <th><?php echo app('translator')->get('Additional Space'); ?></th>
                                <th><?php echo app('translator')->get('Amenities'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $eventSpaces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($event->type); ?></td>
                                <td><?php echo e($event->room); ?></td>
                                <td><?php echo e($event->floor); ?></td>
                                <td><?php echo e($event->size); ?></td>
                                <td><?php echo e($event->additional_space); ?></td>
                                <td><?php echo e($event->amenities); ?></td>
                                <td>
                                    <?php
                                        echo $event->statusBadge($event->status);
                                    ?>
                                </td>


                                <td>
                                    <a href="<?php echo e(route('admin.officeandeventspace.edit',$event->id)); ?>" title="<?php echo app('translator')->get('Edit'); ?>" class="btn btn-sm btn--primary updateService ">
                                        <i class="las la-edit"></i>
                                    </a>
                                    <button title="<?php echo app('translator')->get('Remove'); ?>"
                                     data-id="<?php echo e($event->id); ?>"
                                        class="btn btn-sm btn--danger rejectBtn">
                                        <i class="las la-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                            <?php endif; ?>

                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
        </div><!-- card end -->
    </div>
</div>



<div id="rejectModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Delete Office and Event Space Confirmation'); ?></h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="<?php echo e(route('admin.officeandeventspace.delete')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id">
                <div class="modal-body">
                    <p><?php echo app('translator')->get('Are you sure to'); ?> <span class="fw-bold"><?php echo app('translator')->get('delete'); ?></span> <span
                            class="fw-bold withdraw-amount text-success"></span> <?php echo app('translator')->get('this office and event space'); ?> <span
                            class="fw-bold withdraw-user"></span>?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--danger btn-global"><?php echo app('translator')->get('Delete'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
<a href="<?php echo e(route('admin.officeandeventspace.create')); ?>"  class="btn btn-sm btn--primary">
    <?php echo app('translator')->get('Add Office and Event Space'); ?></a>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
      (function($){
        "use strict";

    $('.rejectBtn').on('click', function () {
            var modal = $('#rejectModal');
            modal.find('input[name=id]').val($(this).data('id'));
            modal.modal('show');
        });

    })(jQuery);
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/phokpisethsambo/prestige-website/application/resources/views/admin/office_and_event_space/index.blade.php ENDPATH**/ ?>