<?php $__env->startSection('panel'); ?>

<div class="row mb-none-30">
    <div class="col-lg-12 mb-30">
        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('admin.reportinside.update',$report->id)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="title" class="font-weight-bold"><?php echo app('translator')->get('Title'); ?></label>
                                <input type="text" name="title" id="title" value="<?php echo e(old('title')??$report->title); ?>"
                                    class="form-control " placeholder="<?php echo app('translator')->get('Title'); ?>"
                                    required>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="download_report_external_url" class="font-weight-bold"><?php echo app('translator')->get('Download Report Url'); ?></label>
                                <input type="text" name="download_report_external_url" id="download_report_external_url" value="<?php echo e(old('download_report_external_url')??$report->download_report_external_url); ?>"
                                    class="form-control " placeholder="<?php echo app('translator')->get('Download Report Url'); ?>">
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="download_report_file" class="font-weight-bold">
                                    <?php echo app('translator')->get('Download Report File'); ?> (PDF)
                                </label>
                                <input type="file" name="download_report_file" id="download_report_file" class="form-control">

                                <?php if($report->download_report_file): ?>
                                    <div class="mt-2">
                                        <strong><?php echo app('translator')->get('Current File'); ?>:</strong><br>
                                        <a href="<?php echo e(asset(getFilePath('reportInsideImage') . '/' . $report->download_report_file)); ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                                            <i class="la la-file-pdf"></i> <?php echo app('translator')->get('View PDF'); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>


                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="category" class="font-weight-bold"><?php echo app('translator')->get('Category'); ?></label>
                                <select name="category" id="category" class="form-control " required>
                                    <option value="">-- <?php echo app('translator')->get('Choose category'); ?> --</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>" <?php echo e($report->category_id==$category->id ? 'selected': ''); ?>><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="image" class="font-weight-bold"><?php echo app('translator')->get('Image'); ?>(600x200)</label>
                                <div class="file-upload-wrapper" data-text="Select your image!">
                                    <input type="file" name="image" id="image" class="file-upload-field">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="status" class="font-weight-bold"><?php echo app('translator')->get('Status'); ?></label>
                                <select name="status" id="status" class="form-control " required>
                                    <option value="0" <?php echo e($report->status==0 ? 'selected': ''); ?>><?php echo app('translator')->get('Inactive'); ?></option>
                                    <option value="1" <?php echo e($report->status==1 ? 'selected': ''); ?>><?php echo app('translator')->get('Active'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12">
                                <h5 class="font-weight-bold"><?php echo app('translator')->get('Old Image'); ?></h5>
                                <img src="<?php echo e(getImage(getFilePath('reportInsideImage').'/'.$report->image)); ?>" class="rounded" alt="report"   style="width:150px;">
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="type" class="font-weight-bold"><?php echo app('translator')->get('Description'); ?></label>
                                <textarea class="trumEdit" name="description"
                                placeholder="<?php echo app('translator')->get('Description'); ?>" id="description" cols="40"
                                rows="10"><?php echo $report->description; ?></textarea>
                            </div>
                        </div>
                        <div class="row text-end">
                            <div class="col-lg-12 ">
                                <div class="form-group float-end p-3">
                                    <button type="submit" class="btn btn--primary btn-block btn-lg"> <?php echo app('translator')->get('Update'); ?></button>
                                </div>
                            </div>
                        </div>
                 </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
<a href="<?php echo e(route('admin.reportinside.index')); ?>" class="btn btn-sm btn--primary box--shadow1 text--small"><i
        class="las la-angle-double-left"></i><?php echo app('translator')->get('Go Back'); ?></a>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('style'); ?>
<style>
    .ck-placeholder{
        height: 190px !important;
    }
</style>
<?php $__env->stopPush(); ?>





<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/phokpisethsambo/prestige-website/application/resources/views/admin/report_and_inside/edit.blade.php ENDPATH**/ ?>