<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Your Report Download</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: linear-gradient(135deg, #00c9d4 0%, #00b4d8 100%);
            color: white;
            padding: 30px;
            text-align: center;
            border-radius: 8px 8px 0 0;
        }
        .content {
            background: #f8f9fa;
            padding: 30px;
            border-radius: 0 0 8px 8px;
        }
        .button {
            display: inline-block;
            padding: 14px 28px;
            background: #00c9d4;
            color: white !important;
            text-decoration: none;
            border-radius: 6px;
            margin: 20px 0;
            font-weight: bold;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            color: #666;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Thank You for Your Interest!</h1>
    </div>

    <div class="content">
        <p>Dear <?php echo e($first_name); ?>,</p>

        <p>Thank you for requesting <strong><?php echo e($report_title); ?></strong>.</p>

        <p>You can download your report by clicking the button below:</p>

        <div style="text-align: center;">
            <a href="<?php echo e($download_url); ?>" class="button">Download Report</a>
        </div>

        <p>If the button doesn't work, you can also copy and paste this link into your browser:</p>
        <p style="word-break: break-all; color: #00c9d4;"><?php echo e($download_url); ?></p>

        <p>We hope you find this report valuable and insightful.</p>

        <p>Best regards,<br>
        <strong>Prestige Alliance Team</strong></p>
    </div>

    <div class="footer">
        <p>&copy; <?php echo e(date('Y')); ?> Prestige Alliance. All rights reserved.</p>
        <p>This email was sent because you requested a report download from our website.</p>
    </div>
</body>
</html>
<?php /**PATH /Users/phokpisethsambo/prestige-website/application/resources/views/emails/report_download_user.blade.php ENDPATH**/ ?>