<?php $__env->startSection('content'); ?>
<?php
    $report_inside = getContent('report_inside.content',true);
?>

<!-- ==================== Service Start Here ==================== -->
<section class="service-area section-bg py-80 ">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-lg-12">
                <h3 class="text-center fw-bold text-base"><?php echo e($report_inside->data_values->title); ?></h3>
            </div>
            <div class="col-lg-12 mt-3">
                <p class="text-center">
                    <?php echo e($report_inside->data_values->short_description); ?>

                </p>
            </div>
        </div>

        <div class="row gy-4 mt-4">
            <div class="col-12 row display-flex">
                <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12 col-lg-4">
                    <img src="<?php echo e(getImage(getFilePath('reportInsideImage').'/'.$item->image)); ?>" alt="<?php echo e($item->title); ?>" class="w-100">
                </div>
                <div class="col-12 col-lg-8 pb-4">
                    <h5 class="mt-4"><a href="<?php echo e(route('report_and_inside.details', $item->slug)); ?>" class="text-base"><?php echo e($item->title); ?></a></h5>
                    <p class="mt-2"><?php echo e(substr(strip_tags(__($item->description)), 0, 500) . '...'); ?></p>
                    <?php if($item->download_report_file): ?>
                    <button type="button" class="btn btn-info mt-2 download-report-btn"
                            data-report-id="<?php echo e($item->id); ?>"
                            data-url="<?php echo e(asset(getFilePath('reportInsideImage').'/'.$item->download_report_file)); ?>"
                            data-title="<?php echo e($item->title); ?>"
                            data-type="file">
                        <?php echo e(__('Download Report')); ?> <i class="fas fa-download"></i>
                    </button>
                    <?php else: ?>
                    <button type="button" class="btn btn-info mt-2 download-report-btn"
                            data-report-id="<?php echo e($item->id); ?>"
                            data-url="<?php echo e($item->download_report_external_url); ?>"
                            data-title="<?php echo e($item->title); ?>"
                            data-type="external">
                        <?php echo e(__('Download Report')); ?> <i class="fas fa-external-link-alt"></i>
                    </button>
                    <?php endif; ?>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="col-sm-12">
                <nav>
                    <ul class="pagination mt-3">
                        <?php if($reports->hasPages()): ?>
                        <div class="py-4">
                            <?php echo e(paginateLinks($reports)); ?>

                        </div>
                        <?php endif; ?>
                    </ul>
                </nav>
            </div>
        </div>
    </div>
</section>
<!-- ==================== Service End Here ==================== -->

<!-- Download Report Modal -->
<div class="modal fade" id="downloadReportModal" tabindex="-1" aria-labelledby="downloadReportModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="border-radius: 20px; border: none; box-shadow: 0 10px 40px rgba(0,0,0,0.1);">
            <div class="modal-body p-4 p-md-5">
                <button type="button" class="btn-close position-absolute" data-bs-dismiss="modal" aria-label="Close" style="top: 20px; right: 20px;"></button>

                <h4 class="mb-4" style="color: #2c4a7c; font-weight: 600;"><?php echo e(__('Download this Report')); ?></h4>

                <form id="downloadReportForm">
                    <div class="row g-3 mb-3">
                        <div class="col-md-6">
                            <input type="text" class="form-control" id="firstName" name="first_name" placeholder="<?php echo e(__('First name')); ?>" required
                                   style="background-color: #f0f2f5; border: none; border-radius: 12px; padding: 16px 20px; font-size: 16px;">
                        </div>
                        <div class="col-md-6">
                            <input type="text" class="form-control" id="lastName" name="last_name" placeholder="<?php echo e(__('Last name')); ?>" required
                                   style="background-color: #f0f2f5; border: none; border-radius: 12px; padding: 16px 20px; font-size: 16px;">
                        </div>
                    </div>

                    <div class="mb-4">
                        <input type="email" class="form-control" id="email" name="email" placeholder="<?php echo e(__('Email address')); ?>" required
                               style="background-color: #f0f2f5; border: none; border-radius: 12px; padding: 16px 20px; font-size: 16px;">
                    </div>

                    <input type="hidden" id="reportId" name="report_id">
                    <input type="hidden" id="downloadUrl" name="download_url">
                    <input type="hidden" id="reportTitle" name="report_title">

                    <button type="submit" class="btn w-100" style="  background: linear-gradient(135deg, #5fc3c9 0%, #4db8be 100%); color: white; border: none; border-radius: 12px; padding: 18px 20px; font-size: 18px; font-weight: 600;">
                        <i class="fas fa-download me-2"></i><?php echo e(__('Download Report Now')); ?>

                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('script'); ?>
<script>
(function() {
    'use strict';

    // Wait for page to fully load
    window.addEventListener('load', function() {
        const downloadBtns = document.querySelectorAll('.download-report-btn');
        const modalElement = document.getElementById('downloadReportModal');
        const form = document.getElementById('downloadReportForm');

        console.log('Modal found:', modalElement);
        console.log('Form found:', form);
        console.log('Download buttons found:', downloadBtns.length);

        if (!modalElement) {
            console.error('Modal element not found');
            return;
        }

        if (!form) {
            console.error('Form element not found');
            return;
        }

        let modalInstance = null;

        // Initialize Bootstrap modal
        try {
            if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
                modalInstance = new bootstrap.Modal(modalElement);
            } else if (typeof $ !== 'undefined' && $.fn.modal) {
                // Fallback to jQuery if Bootstrap 5 not available
                modalInstance = {
                    show: function() { $(modalElement).modal('show'); },
                    hide: function() { $(modalElement).modal('hide'); }
                };
            }
        } catch (e) {
            console.error('Error initializing modal:', e);
        }

        // Add click event to download buttons
        downloadBtns.forEach(function(btn) {
            btn.addEventListener('click', function(e) {
                e.preventDefault();

                const reportId = this.getAttribute('data-report-id');
                const url = this.getAttribute('data-url');
                const title = this.getAttribute('data-title');

                console.log('Download button clicked:', reportId, url, title);

                // Query hidden inputs when button is clicked
                const reportIdInput = form.querySelector('#reportId') || form.querySelector('input[name="report_id"]');
                const downloadUrlInput = form.querySelector('#downloadUrl') || form.querySelector('input[name="download_url"]');
                const reportTitleInput = form.querySelector('#reportTitle') || form.querySelector('input[name="report_title"]');

                console.log('Hidden inputs found:', {reportIdInput, downloadUrlInput, reportTitleInput});

                if (reportIdInput && downloadUrlInput && reportTitleInput) {
                    reportIdInput.value = reportId;
                    downloadUrlInput.value = url;
                    reportTitleInput.value = title;
                    console.log('Hidden inputs set:', {reportId, url, title});
                } else {
                    console.error('Could not find hidden inputs!');
                }

                if (modalInstance) {
                    modalInstance.show();
                } else {
                    // Direct fallback
                    modalElement.classList.add('show');
                    modalElement.style.display = 'block';
                    document.body.classList.add('modal-open');
                }
            });
        });

        // Handle form submission
        if (form) {
            form.addEventListener('submit', function(e) {
                e.preventDefault();

                // Get values directly from form elements
                const firstNameInput = form.querySelector('#firstName') || form.querySelector('input[name="first_name"]');
                const lastNameInput = form.querySelector('#lastName') || form.querySelector('input[name="last_name"]');
                const emailInput = form.querySelector('#email') || form.querySelector('input[name="email"]');

                // Query hidden inputs again at submit time
                const reportIdInput = form.querySelector('#reportId') || form.querySelector('input[name="report_id"]');
                const downloadUrlInput = form.querySelector('#downloadUrl') || form.querySelector('input[name="download_url"]');
                const reportTitleInput = form.querySelector('#reportTitle') || form.querySelector('input[name="report_title"]');

                const firstName = (firstNameInput?.value || '').trim();
                const lastName = (lastNameInput?.value || '').trim();
                const email = (emailInput?.value || '').trim();
                const reportId = reportIdInput?.value || '';
                const downloadUrl = downloadUrlInput?.value || '';
                const reportTitle = reportTitleInput?.value || '';                console.log('Form values:', {firstName, lastName, email, reportId, downloadUrl, reportTitle});

                // Validate inputs
                if (!firstName || !lastName || !email) {
                    console.error('Validation failed. Missing:', {
                        firstName: !firstName,
                        lastName: !lastName,
                        email: !email
                    });
                    alert('Please fill in all required fields');
                    return;
                }

                if (!reportId) {
                    alert('Report ID is missing. Please try again.');
                    console.error('Missing reportId. Inputs:', {reportIdInput, downloadUrlInput, reportTitleInput});
                    return;
                }

                console.log('Validation passed! Proceeding with submission...');

                // Disable submit button
                const submitBtn = form.querySelector('button[type="submit"]');
                submitBtn.disabled = true;
                submitBtn.innerHTML = 'Processing... <i class="fas fa-spinner fa-spin"></i>';

                // Send data to backend
                console.log('Sending request to:', '<?php echo e(route("report.download")); ?>');
                console.log('Data:', {
                    report_id: reportId,
                    first_name: firstName,
                    last_name: lastName,
                    email: email
                });

                fetch('<?php echo e(route("report.download")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({
                        report_id: reportId,
                        first_name: firstName,
                        last_name: lastName,
                        email: email
                    })
                })
                .then(response => {
                    console.log('Response status:', response.status);
                    console.log('Response headers:', response.headers);

                    if (!response.ok) {
                        return response.text().then(text => {
                            console.error('Error response:', text);
                            throw new Error('Server returned ' + response.status);
                        });
                    }
                    return response.json();
                })
                .then(data => {
                    console.log('Response data:', data);

                    if (data.success) {
                        // Close modal
                        if (modalInstance) {
                            modalInstance.hide();
                        } else {
                            modalElement.classList.remove('show');
                            modalElement.style.display = 'none';
                            document.body.classList.remove('modal-open');
                            const backdrop = document.querySelector('.modal-backdrop');
                            if (backdrop) backdrop.remove();
                        }

                        // Show success message
                        alert(data.message || 'Thank you! Check your email for the download link.');

                        // Open download
                        window.open(data.download_url || downloadUrl, '_blank');

                        // Reset form
                        form.reset();
                    } else {
                        console.error('Success is false:', data);
                        alert(data.message || 'An error occurred. Please try again.');
                    }
                })
                .catch(error => {
                    console.error('Fetch error:', error);
                    alert('Error: ' + error.message + '. Please check the console for details.');
                })
                .finally(() => {
                    // Re-enable submit button
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = 'Download <i class="fas fa-download"></i>';
                });
            });
        }

        // Handle close button
        const closeButtons = modalElement.querySelectorAll('[data-bs-dismiss="modal"]');
        closeButtons.forEach(function(btn) {
            btn.addEventListener('click', function() {
                if (modalInstance) {
                    modalInstance.hide();
                }
            });
        });
    });
})();
</script>
<?php $__env->stopPush(); ?>

<?php if($sections->secs != null): ?>
<?php $__currentLoopData = json_decode($sections->secs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php echo $__env->make($activeTemplate.'sections.'.$sec, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/phokpisethsambo/prestige-website/application/resources/views/presets/default/report-insides/index.blade.php ENDPATH**/ ?>