<?php $__env->startSection('content'); ?>
<!-- ==================== Service Start Here ==================== -->
<section class="service-area section-bg py-80 blog-area">
    <div class="container">

        <?php if((request()->get('page') == 1 || !request()->get('page')) && $featuredBlog): ?>
        <div class="row">
            <div class="col-12 col-md-8">
                <img src="<?php echo e(getImage(getFilePath('blog').'/'.$featuredBlog->featured_image)); ?>" alt="<?php echo e($featuredBlog->title); ?>" class="rounded w-100 mb-2">
            </div>
            <div class="col-12 col-md-4 ps-5">
                <h5><a href="<?php echo e(route('blog.details', $featuredBlog->slug)); ?>" class="text-base"><?php echo e($featuredBlog->title); ?></a></h5>
                <p class="mt-5"><?php echo e(\Str::limit(strip_tags(html_entity_decode($featuredBlog->description)), 500)); ?></p>
            </div>
        </div>
        <hr class="mt-5">
        <?php endif; ?>

        <div class="row mt-4">
            <div class="col-md-12">
                <div class="blog-grid">
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <?php
                    $truncated_title = \Str::limit(strip_tags(html_entity_decode($item->title)), 80, '...');
                    ?>

                    <div class="blog-post">
                        <div class="image-container">
                            <img src="<?php echo e(getImage(getFilePath('blog').'/'.$item->featured_image)); ?>" alt="<?php echo e($item->title); ?>">
                        </div>
                        <div class="card-body">
                            <h5 class="card-title"><a href="<?php echo e(route('blog.details', $item->slug)); ?>" class="text-base"><?php echo e($truncated_title); ?></a></h5>
                            <small class="post-date"><?php echo e(date('d M Y', strtotime($item->created_at))); ?></small>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="col-md-12">
                <nav>
                    <ul class="pagination mt-3">
                        <?php if($blogs->hasPages()): ?>
                        <div class="py-4">
                            <?php echo e(paginateLinks($blogs)); ?>

                        </div>
                        <?php endif; ?>
                    </ul>
                </nav>
            </div>
        </div>
    </div>
</section>
<!-- ==================== Service End Here ==================== -->

<?php if($sections->secs != null): ?>
<?php $__currentLoopData = json_decode($sections->secs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php echo $__env->make($activeTemplate.'sections.'.$sec, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/phokpisethsambo/prestige-website/application/resources/views/presets/default/blog/index.blade.php ENDPATH**/ ?>