<?php

use App\Lib\Router;
use Illuminate\Support\Facades\Route;

Route::get('/down', function () {
    \Illuminate\Support\Facades\Artisan::call('down');
});

Route::get('/live', function () {
    \Illuminate\Support\Facades\Artisan::call('up');
});

Route::get('/clear', function(){
    \Illuminate\Support\Facades\Artisan::call('optimize:clear');
});

// User Support Ticket
Route::controller('TicketController')->prefix('ticket')->group(function () {
    Route::get('/', 'supportTicket')->name('ticket');
    Route::get('/new', 'openSupportTicket')->name('ticket.open');
    Route::post('/create', 'storeSupportTicket')->name('ticket.store');
    Route::get('/view/{ticket}', 'viewTicket')->name('ticket.view');
    Route::post('/reply/{ticket}', 'replyTicket')->name('ticket.reply');
    Route::post('/close/{ticket}', 'closeTicket')->name('ticket.close');
    Route::get('/download/{ticket}', 'ticketDownload')->name('ticket.download');
});

Route::get('app/deposit/confirm/{hash}', 'Gateway\PaymentController@appDepositConfirm')->name('deposit.app.confirm');

Route::controller('SiteController')->group(function () {
    Route::get('/contact', 'contact')->name('contact');
    Route::post('/contact', 'contactSubmit');
    Route::get('/change/{lang?}', 'changeLanguage')->name('lang');

    Route::get('cookie-policy', 'cookiePolicy')->name('cookie.policy');

    Route::get('/cookie/accept', 'cookieAccept')->name('cookie.accept');

    Route::get('policy/{slug}/{id}', 'policyPages')->name('policy.pages');

    Route::get('placeholder-image/{size}', 'placeholderImage')->name('placeholder.image');

    // blog
    Route::get('/blog','blog')->name('blog');
    Route::get('/blog/{slug}', 'blogDetails')->name('blog.details');

    // plan
    Route::get('/plan','plan')->name('plans');

    // services
    Route::get('/services','services')->name('services');
    Route::get('/service/{slug}/{id}', 'serviceDetails')->name('service.details');

    // portfolio
    Route::get('/portfolio','portfolio')->name('portfolio');
    Route::get('/portfolio/{slug}/{id}', 'portfolioDetails')->name('portfolio.details');

    // subscriber
    Route::post('/subscribe','subscribe')->name('subscribe');

    // About
    Route::get('/about','about');

    // report-and-inside
    Route::get('/reports-and-insights','reportAndInside')->name('report_and_inside');
    Route::get('/reports-and-insights/{slug}', 'reportAndInsideDetails')->name('report_and_inside.details');

    // NEW: REPORT DOWNLOAD POST ROUTE
    Route::post('/download-report', [App\Http\Controllers\ReportDownloadController::class, 'store'])
        ->name('report.download');

    // Careers
    Route::get('/career-center','careerCenter')->name('career_center');
    Route::get('/career-center/{uuid}', 'careerCenterDetails')->name('career_center.details');

    // Office and Event Space
    Route::get('/office-and-event-space','officeEventSpace')->name('officespace');

    // Dynamic pages
    Route::get('/{slug}', 'pages')->name('pages');
    Route::get('/', 'index')->name('home');
});

    // Google Analytics diagnostics (admin/dev use)
    Route::get('/admin/ga-diagnostics', function () {
        $info = [];
        $info['ga_enabled'] = config('services.google_analytics.enabled');
        $info['measurement_id'] = config('services.google_analytics.measurement_id');
        $info['property_id'] = env('GA_PROPERTY_ID');
        $info['service_account_env'] = env('GA_SERVICE_ACCOUNT_JSON') ? true : false;

        $path = env('GA_SERVICE_ACCOUNT_JSON');
        $info['service_account_path_exists'] = $path && file_exists($path);

        // If the env contains raw JSON or base64, attempt a light parse (do not expose private_key)
        if ($path && !file_exists($path)) {
            $maybe = trim($path, "\"'");
            // try base64 decode
            $decoded = base64_decode($maybe, true);
            if ($decoded !== false && strpos(ltrim($decoded), '{') === 0) {
                $json = json_decode($decoded, true);
            } else {
                $json = json_decode($maybe, true);
            }
            if (is_array($json) && !empty($json['client_email'] ?? null)) {
                $info['service_account_client_email'] = $json['client_email'];
            }
        }

        try {
            $svc = app(\App\Services\GoogleAnalyticsService::class);
            $total = $svc->getTotalUsers(\Carbon\Carbon::now()->subDays(30), \Carbon\Carbon::now());
            $info['get_total_users_last_30_days'] = $total;
            // Add detailed diagnostics (will include masked access token and API result or error)
            $info['diagnostics'] = $svc->diagnose();
        } catch (\Exception $e) {
            $info['error'] = $e->getMessage();
        }

        return response()->json($info);
    });
