@extends($activeTemplate.'layouts.frontend')
@section('content')

@include($activeTemplate.'sections.new.counter')

<section class="service-area section-bg py-80 service-wrapper">
    <div class="container">

        @foreach ($services as $item)

        <div class="service-center-wrapper py-3">

            <div class="row gx-3 align-items-center">

                <div class="col-lg-2 col-md-3 col-3 p-3">
                    <div class="service__icon-box">
                        @php echo $item->icon; @endphp
                    </div>
                </div>

                <div class="col-lg-10 col-md-9 col-9 p-3">
                    <h3 class="text-base fw-bold service-item__title">
                        {{ __($item->title) }}
                    </h3>

                    <p class="service-item__description mb-0">
                        {{ strip_tags(__($item->description)) }}
                    </p>
                </div>

            </div>

        </div>

        @if (!$loop->last)
            <hr class="service-divider">
        @endif

        @endforeach

    </div>

    <div class="w-100 mt-5">
        <img src="{{ asset('assets/images/frontend/others/bg-service1.jpg') }}">
    </div>

</section>

@if($sections->secs != null)
@foreach(json_decode($sections->secs) as $sec)
@include($activeTemplate.'sections.'.$sec)
@endforeach
@endif

@endsection


