@php
$testimonial = getContent('testimonial.content',true);
$testimonialElements = getContent('testimonial.element',false);
@endphp
<!--========================== Testimonials Section Start ==========================-->
<section class="testimonials section-bg py-80 ">

    <div class="bg-base testimonial-quote mb-5 position-relative">
    {{-- <div class="bg-base testimonial-quote mb-5 position-relative" data-aos="zoom-in-right" data-aos-easing="ease-out-cubic" data-aos-duration="1000"> --}}
        <div class="container">
            <h2 class="text-white testimonial-quote__text position-relative lh-base">
                <div class="testimonial-quote__icon-left">
                    <img src="{{ asset('assets/images/frontend/others/prestige-icon-white.png') }}">
                </div>
                {!! nl2br($testimonial->data_values->subheading) !!}

                <div class="testimonial-quote__icon-right">
                    <img src="{{ asset('assets/images/frontend/others/prestige-icon-white.png') }}">
                </div>
            </h2>
        </div>
    </div>

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="section-heading  text-center">
                    <h3 class="text-center fw-bold text-base">{{__($testimonial->data_values->heading)}}</h3>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            @foreach ($testimonialElements as $item)
            <div class="col-lg-3 col-md-3">
            {{-- <div class="col-lg-3 col-md-3" data-aos="flip-down" data-aos-easing="ease-out-cubic" data-aos-duration="2000"> --}}
                <div class="text-center">
                    <img src="{{getImage(getFilePath('testimonial').'/'.$item->data_values->testimonial_image)}}" class="rounded" alt="testimonial">
                    <p class="text-center text-muted mt-2">
                        <small class="m-auto">{{__($item->data_values->designation)}}</small>
                    </p>
                    <h5 class="text-base text-center fw-bold">{{__($item->data_values->title)}}</h5>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
<!--========================== Testimonials Section End ==========================-->
