@php
$service = getContent('service.content',true);
$services = App\Models\Service::where('status',1)->orderBy('created_at','desc')->take(5)->get();
@endphp

<!-- ==================== Service Start Here ==================== -->
<section class="service-area section-bg py-80 full-vh">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <h3 class="text-center fw-bold text-base">
                    {{ __($service->data_values->heading) }}
                </h3>
            </div>
        </div>

        <!-- Desktop Accordion View -->
        <div class="service-accordion-row mt-5 d-none d-lg-flex">
            @foreach ($services as $index => $item)
            <div class="service-accordion-item" data-index="{{ $index }}">
                <div class="service-accordion-content">

                    <!-- Prestige Logo -->
                    <div class="blockquote-custom-icon">
                        <img src="{{ asset('assets/images/frontend/others/prestige-icon.png') }}"
                             class="prestige-icon-lower">
                    </div>

                    <!-- Service Icon -->
                    <div class="service__icon">
                        @if ($item->custom_icon)
                            <img src="{{ getImage(getFilePath('serviceFile').'/'.$item->custom_icon) }}">
                        @else
                            @php echo $item->icon; @endphp
                        @endif
                    </div>

                    <!-- Title -->
                    <h3 class="service-accordion-title">
                        {{ __($item->title) }}
                    </h3>

                    <!-- Description -->
                    <div class="service-accordion-description">
                        <p>
                            {!! strip_tags(__($item->description)) !!}
                        </p>
                    </div>

                </div>
            </div>
            @endforeach
        </div>

        <!-- Mobile Slider View -->
        <div class="service-mobile-slider mt-5 d-lg-none">
            <div class="service-slider-wrapper">
                <!-- Slider Navigation -->
                <button class="slider-btn slider-prev" aria-label="Previous">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polyline points="15,18 9,12 15,6"></polyline>
                    </svg>
                </button>
                <button class="slider-btn slider-next" aria-label="Next">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polyline points="9,18 15,12 9,6"></polyline>
                    </svg>
                </button>

                <div class="service-slider-track">
                    @foreach ($services as $index => $item)
                    <div class="service-slide" data-index="{{ $index }}">
                        <div class="service-slide-content">

                            <!-- Prestige Logo -->
                            <div class="blockquote-custom-icon">
                                <img src="{{ asset('assets/images/frontend/others/prestige-icon.png') }}"
                                     class="prestige-icon-lower">
                            </div>

                            <!-- Service Icon -->
                            <div class="service__icon">
                                @if ($item->custom_icon)
                                    <img src="{{ getImage(getFilePath('serviceFile').'/'.$item->custom_icon) }}">
                                @else
                                    @php echo $item->icon; @endphp
                                @endif
                            </div>

                            <!-- Title -->
                            <h3 class="service-accordion-title">
                                {{ __($item->title) }}
                            </h3>

                            <!-- Description -->
                            <div class="service-slide-description">
                                <p>
                                    @if(strlen(strip_tags(__($item->description))) > 250)
                                        {!! substr(strip_tags(__($item->description)), 0, 250) . '...' !!}
                                    @else
                                        {!! strip_tags(__($item->description)) !!}
                                    @endif
                                </p>
                            </div>

                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            <!-- Slider Dots -->
            <div class="service-slider-controls">
                <div class="slider-dots"></div>
            </div>
        </div>
    </div>
</section>
<!-- ==================== Service End Here ==================== -->

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Desktop Accordion
    const row = document.querySelector('.service-accordion-row');
    const items = document.querySelectorAll('.service-accordion-item');

    if (window.innerWidth > 991) {
        // Make first item active by default for visual balance and remember last active
        let lastActiveIndex = 0;
        if (items.length) {
            items[0].classList.add('active');
            lastActiveIndex = 0;
        }

        items.forEach((item, idx) => {
            item.addEventListener('mouseenter', function () {
                items.forEach(i => i.classList.remove('active'));
                this.classList.add('active');
                lastActiveIndex = idx;
            });
        });

        // Keep the last active item active even if the mouse leaves the row or when scrolling.
        function ensureLastActive() {
            items.forEach(i => i.classList.remove('active'));
            if (items[lastActiveIndex]) items[lastActiveIndex].classList.add('active');
        }

        // Reapply the active state after quick scroll/resize events (debounced)
        window.addEventListener('scroll', function () {
            clearTimeout(window.__serviceActiveScrollTimeout);
            window.__serviceActiveScrollTimeout = setTimeout(ensureLastActive, 80);
        }, { passive: true });

        window.addEventListener('resize', function () {
            clearTimeout(window.__serviceActiveResizeTimeout);
            window.__serviceActiveResizeTimeout = setTimeout(ensureLastActive, 120);
        });
    }

    // Mobile Slider
    const slider = document.querySelector('.service-mobile-slider');
    if (slider && window.innerWidth <= 991) {
        const track = slider.querySelector('.service-slider-track');
        const slides = slider.querySelectorAll('.service-slide');
        const prevBtn = slider.querySelector('.slider-prev');
        const nextBtn = slider.querySelector('.slider-next');
        const dotsContainer = slider.querySelector('.slider-dots');

        let currentIndex = 0;
        let autoSlideInterval;
        const totalSlides = slides.length;
        const autoSlideDelay = 4000; // 4 seconds

        // Create dots
        slides.forEach((_, index) => {
            const dot = document.createElement('button');
            dot.classList.add('slider-dot');
            if (index === 0) dot.classList.add('active');
            dot.setAttribute('aria-label', `Go to slide ${index + 1}`);
            dot.addEventListener('click', () => goToSlide(index));
            dotsContainer.appendChild(dot);
        });

        const dots = dotsContainer.querySelectorAll('.slider-dot');

        function updateSlider() {
            track.style.transform = `translateX(-${currentIndex * 100}%)`;
            dots.forEach((dot, index) => {
                dot.classList.toggle('active', index === currentIndex);
            });
        }

        function goToSlide(index) {
            currentIndex = index;
            updateSlider();
            resetAutoSlide();
        }

        function nextSlide() {
            currentIndex = (currentIndex + 1) % totalSlides;
            updateSlider();
        }

        function prevSlide() {
            currentIndex = (currentIndex - 1 + totalSlides) % totalSlides;
            updateSlider();
        }

        function startAutoSlide() {
            autoSlideInterval = setInterval(nextSlide, autoSlideDelay);
        }

        function resetAutoSlide() {
            clearInterval(autoSlideInterval);
            startAutoSlide();
        }

        // Event listeners
        prevBtn.addEventListener('click', () => {
            prevSlide();
            resetAutoSlide();
        });

        nextBtn.addEventListener('click', () => {
            nextSlide();
            resetAutoSlide();
        });

        // Touch/Swipe support
        let touchStartX = 0;
        let touchEndX = 0;

        track.addEventListener('touchstart', (e) => {
            touchStartX = e.changedTouches[0].screenX;
        }, { passive: true });

        track.addEventListener('touchend', (e) => {
            touchEndX = e.changedTouches[0].screenX;
            handleSwipe();
        }, { passive: true });

        function handleSwipe() {
            const swipeThreshold = 50;
            const diff = touchStartX - touchEndX;

            if (Math.abs(diff) > swipeThreshold) {
                if (diff > 0) {
                    nextSlide();
                } else {
                    prevSlide();
                }
                resetAutoSlide();
            }
        }

        // Start auto slide
        startAutoSlide();

        // Pause on hover/touch
        slider.addEventListener('mouseenter', () => clearInterval(autoSlideInterval));
        slider.addEventListener('mouseleave', startAutoSlide);
    }

    // Dynamically set the full-vh section height to account for actual header height
    function updateServiceSectionHeight() {
        const section = document.querySelector('.service-area.full-vh');
        if (!section) return;
        const header = document.getElementById('main-header') || document.querySelector('.header') || document.querySelector('header');
        const headerHeight = header ? Math.ceil(header.getBoundingClientRect().height) : 120;
        // set CSS var on the section and apply calculated height
        section.style.setProperty('--header-height', headerHeight + 'px');
        section.style.height = `calc(100vh - ${headerHeight}px)`;
    }

    // Run on load and resize (debounced)
    updateServiceSectionHeight();
    window.addEventListener('resize', function(){
        clearTimeout(window.__serviceSectionResizeTimeout);
        window.__serviceSectionResizeTimeout = setTimeout(updateServiceSectionHeight, 120);
    });

});
</script>
@endpush

{{-- Styles moved to assets/presets/default/css/prestige.css to avoid inline pushes --}}

