@php
$counter = getContent('counter.content',true);
$counterElements = getContent('counter.element',false,4);
 @endphp
<!-- ==================== Experience Start Here ==================== -->
<section class="section-bg py-80 counter-section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <h3 class="text-center fw-bold text-base">{{__($counter->data_values->top_heading)}}</h3>
                <!-- <div class="section-heading  text-center">
                    <span class="subtitle">{{__($counter->data_values->top_heading)}}</span>
                    <h2 class="section-heading__title">{{__($counter->data_values->heading)}}</h2>
                </div> -->
            </div>
        </div>
        <div class="row gy-4 justify-content-center mt-4">
            @foreach($counterElements as $item)
            @php
                $defaultCount = $item->data_values->counter_digit ?? 0;
                $title = strtolower(trim($item->data_values->title ?? ''));
                // Skip any counter elements that are meant to show page views
                if(\Illuminate\Support\Str::contains($title, 'view') || \Illuminate\Support\Str::contains($title, 'viewer')){
                    continue;
                }
                // Map common titles to dynamic totals when available
                if(isset($totals) && is_array($totals)){
                    if(\Illuminate\Support\Str::contains($title, 'user')){
                        $display = $totals['users'];
                    }elseif(\Illuminate\Support\Str::contains($title, 'service')){
                        $display = $totals['services'];
                    }elseif(\Illuminate\Support\Str::contains($title, 'portfolio')){
                        $display = $totals['portfolios'];
                    }elseif(\Illuminate\Support\Str::contains($title, 'download')){
                        $display = $totals['downloads'];
                    }elseif(\Illuminate\Support\Str::contains($title, 'deposit')){
                        // use integer value for odometer; formatting can be shown separately if needed
                        $display = (int) $totals['deposits'];
                    }elseif(\Illuminate\Support\Str::contains($title, 'view') || \Illuminate\Support\Str::contains($title, 'viewer')){
                        // show website viewers from Google Analytics if available
                        $display = isset($totals['viewers']) && $totals['viewers'] !== null ? $totals['viewers'] : $defaultCount;
                    }elseif(\Illuminate\Support\Str::contains($title, 'order')){
                        $display = $totals['orders'];
                    }else{
                        $display = $defaultCount;
                    }
                }else{
                    $display = $defaultCount;
                }
                // ensure integer for the odometer counter
                $displayCount = is_numeric($display) ? (int) $display : $display;
            @endphp
            <div class="col-lg-4 col-md-4 col-4">
                <div class="text-center odometer-wrapper">
                    <h1 class="text-base counter-number"><span class="odometer" data-count="{{ $displayCount }}"></span><span class="letter align-top counter-plus">+</span></h1>
                    <p>{{__($item->data_values->title)}}</p>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
<!-- ==================== Experience End Here ==================== -->

<style>
.counter-section {
    min-height: 100vh;
    display: flex;
    align-items: center;
}
.counter-number {
    font-size: 5rem;
}
.counter-plus {
    font-size: 3rem;
}
@media (max-width: 768px) {
    .counter-section {
        min-height: auto;
        padding: 60px 0;
    }
    .counter-number {
        font-size: 2.5rem;
    }
    .counter-plus {
        font-size: 1.5rem;
    }
}
</style>
