@php
$blog = getContent('blog.content',true);
// $blogElements = getContent('blog.element',false,3);
$blogs = \App\Models\News::where('status',1)->orderBy('created_at', 'desc')->limit(3)->get();
@endphp
<!-- ==================== Blog Start Here ==================== -->
<section class="blog py-80 blog-area">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="section-heading  text-center">
                    <h3 class="text-center fw-bold text-base">{{__($blog->data_values->heading)}}</h3>
                </div>
            </div>
        </div>
        <div class="row gy-4 justify-content-center">
            <a href="/blog" class="text-end text-base">View all</a>
            <!-- Lastest Blog -->
            <div class="col-lg-12 mb-4">
                <div class="blog-grid">
                    @foreach ($blogs as $item)
                        @php
                        $truncated_title = \Str::of(strip_tags(__($item->title)))->limit(80, '...');
                        @endphp

                        <div class="blog-post">
                            <div class="image-container">
                                <img src="{{getImage(getFilePath('blog').'/'.$item->featured_image)}}" alt="{{ $item->title }}">
                            </div>
                            <div class="card-body">
                                <h5 class="card-title"><a href="{{ route('blog.details', $item->slug) }}" class="text-base">{{ $truncated_title }}</a></h5>
                                <small  class="post-date">{{ date('d M Y', strtotime($item->created_at)) }}</small>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ==================== Blog End Here ==================== -->
