@extends($activeTemplate.'layouts.frontend')
@section('content')
<!-- ==================== Service Start Here ==================== -->
<section class="service-area section-bg py-80 ">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-lg-12">
                <h3 class="text-center fw-bold text-base">{{__($portfolio->data_values->heading)}}</h3>
            </div>
            <div class="col-lg-12 mt-3">
                <p class="text-center">{{__($portfolio->data_values->sub_heading)}}</p>
            </div>
        </div>

        <div class="row gy-4 portfolio-wrapper">
            @foreach ($portfolios as $item)
                @php
                $is_event = false;
                if ($loop->index % 2 == 0) {
                    $is_event = true;
                } else {
                    $is_event = false;
                }
                @endphp
            <div class="col-lg-4 col-md-4 col-6 d-flex align-items-stretch rounded portfolio-item">
                <div class="card rounded">
                    <img src="{{getImage(getFilePath('portfolioImage').'/'.$item->image)}}" class="card-img-top rounded">
                    <div class="card-body d-flex flex-column p-0 rounded {{ $is_event ? 'bg-base' : 'bg-base-light' }}">
                        <p class="card-text p-4 text-white ">
                            @if(strlen(__($item->sub_title)) >140)
                            {{substr( __($item->sub_title), 0,140).'...' }}
                            @else
                            {{__($item->sub_title)}}
                            @endif
                        </p>
                    </div>
                </div>
            </div>
            @endforeach

            <div class="col-sm-12">
                <nav>
                    <ul class="pagination mt-3">
                        @if ($portfolios->hasPages())
                        <div class="py-4">
                            {{ paginateLinks($portfolios) }}
                        </div>
                        @endif
                    </ul>
                </nav>
            </div>
        </div>
    </div>
</section>
<!-- ==================== Service End Here ==================== -->

@include($activeTemplate.'sections.new.trusted_by')

@if($sections->secs != null)
@foreach(json_decode($sections->secs) as $sec)
@include($activeTemplate.'sections.'.$sec)
@endforeach
@endif
@endsection
