@extends($activeTemplate.'layouts.frontend')

@push('style-lib')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/jquery.webui-popover/1.2.1/jquery.webui-popover.min.css">
@endpush

@section('content')
<!-- ==================== Office and Event Start Here ==================== -->
<section class="office-event-area section-bg py-80">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-lg-12">
                <h3 class="text-center fw-bold text-base">{{__($officeEventSpace->data_values->heading)}}</h3>
            </div>
            <div class="col-lg-12 mt-3">
                <p class="text-center">{{__($officeEventSpace->data_values->sub_heading)}}</p>
            </div>
        </div>

        <div class="row gy-4 mt-4">
            @foreach($officeEventSpaceElements as $item)
            @php 
            $no = $loop->index +1;
            $is_event = false;
            if ($no % 2 == 0) {
                $is_event = true;
            }
            @endphp
            <div class="col-12">
                <div class="row display-flex gx-5">
                    <div class="col-12 col-lg-5  {{ $is_event ? 'order-sm-last' : '' }}">
                        <div class="p-4 border bg-light office-event__space_items">
                            <div class="office-event__space_items-icon">
                                @if ($item->data_values->icon_image)
                                    <img src="{{ getImage(getFilePath('officeEventSpaceImage').'/'.$item->data_values->icon_image) }}">
                                @else
                                    @php echo $item->data_values->icon_image; @endphp
                                @endif
                            </div>
                            <h5 class="fw-bold">{{ $item->data_values->title }}</h5>
                            <p>{{ substr(strip_tags(__($item->data_values->description)), 0, 250) . '...' }}</p>
                        </div>
                    </div>
                    <div class="col-12 col-lg-7">
                        <div class="border office-event__space_items">
                            <img src="{{ getImage(getFilePath('officeEventSpaceImage').'/'.$item->data_values->cover_image) }}" style="width: 100%;">
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
<!-- ==================== Office and Event End Here ==================== -->

<!-- Slide -->
@if ($slides)
<section class="office-event-area section-bg py-80">
    <div class="w-100">
        <div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-indicators">
                @foreach($slides as $slide)
                <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="{{ $loop->index }}" class="{{ $loop->index==0 ? 'active': '' }}" aria-current="true" aria-label="Slide {{ $loop->index+1 }}"></button>
                @endforeach
            </div>
            <div class="carousel-inner">
                @foreach($slides as $slide)
                <div class="carousel-item {{ $loop->index==0 ? 'active': '' }}">
                    <img src="{{ getImage(getFilePath('uploads').'/'.$slide->image) }}" class="d-block w-100" alt="...">
                </div>
                @endforeach
            </div>
            <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Next</span>
            </button>
        </div>
    </div>
</section>
@endif

<section class="office-event-area section-bg py-80">
    <div class="container office-event__container bg-light p-4">
        <div class="row">
            <div class="col-12">
                <div class="office-event__rate-items">
                    <div class="office-event__rate-icon">
                        <img src="{{ asset($activeTemplateTrue.'images/office-icon.png') }}">
                    </div>
                    <h5>Prestige Office Space Rate</h5>
                    <div class="table-responsive">
                        <table class="table-eventspace">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Room</th>
                                    <th>Floor</th>
                                    <th>Size (m)</th>
                                    <th>Additional Space</th>
                                    <th>Amenities</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($offices as $office)
                                <tr>
                                    <td data-title="Type"><span>Type</span> {{ $office->type }}</td>
                                    <td data-title="Room"><span>Room</span> {{ $office->room }}</td>
                                    <td data-title="Floor"><span>Floor</span> {{ $office->floor }}</td>
                                    <td data-title="Size (m)"><span>Size (m)</span> {{ $office->size }}</td>
                                    <td data-title="Additional Space"><span>Additional Space</span> {{ $office->additional_space }}</td>
                                    <td data-title="Amenities"><span>Amenities</span> {{ $office->amenities }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="100%" class="text-center">{{ __($emptyMessage) }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-12 mt-5">
                <div class="office-event__rate-items">
                    <div class="office-event__rate-icon">
                        <img src="{{ asset($activeTemplateTrue.'images/home-icon.png') }}">
                    </div>
                    <h5>Prestige Event Space Rate</h5>
                    <div>
                        <table class="table-eventspace">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Room</th>
                                    <th>Floor</th>
                                    <th>Size (m)</th>
                                    <th>Additional Space</th>
                                    <th>Amenities</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($events as $event)
                                <tr>
                                    <td data-title="Type"><span>Type</span> {{ $event->type }}</td>
                                    <td data-title="Room"><span>Room</span> {{ $event->room }}</td>
                                    <td data-title="Floor"><span>Floor</span> {{ $event->floor }}</td>
                                    <td data-title="Size (m)"><span>Size (m)</span> {{ $event->size }}</td>
                                    <td data-title="Additional Space"><span>Additional Space</span> {{ $event->additional_space }}</td>
                                    <td data-title="Amenities"><span>Amenities</span> {{ $event->amenities }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="100%" class="text-center">{{ __($emptyMessage) }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

<section class="office-event-area section-bg py-80">
    <div class="container" style="background: transparent;">
        <div class="row">
            <div class="col-12 col-lg-5">
                <div class="office-rental__wrapper">
                    <div class="office-rental__icon">
                        <img src="{{ asset($activeTemplateTrue.'images/dolar-icon.png') }}">
                    </div>
                    <h5 class="text-white fw-bold">Price for Rental</h5>
                    <p class="text-white mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo con Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatu Ex</p>
                    <button class="btn btn-info rental-popover mt-5">Contact Us Now!</button>

                    <div id="rental-popover-content" style="display: none;position:relative;">
                        <div class="p-2">
                            <h5 class="text-center text-base">Lorem Ipsum</h5>
                            <small class="text-base">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum is simply dummy text of the printing and typesetting industry.</small>

                            <div class="text-center mt-4">
                                <a href="https://kh.linkedin.com/company/prestigeconsulting289" target="_blank">
                                    <img src="{{ asset($activeTemplateTrue.'images/linkin-icon.png') }}" alt="Linkin" width="45">
                                </a>
                                <a href="{{ $officeEventSpace->data_values->price_rental_googleform }}" target="_blank" class="ms-4">
                                    <img src="{{ asset($activeTemplateTrue.'images/googleform-icon.png') }}" alt="Google Form" width="85">
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>

@if($sections->secs != null)
@foreach(json_decode($sections->secs) as $sec)
@include($activeTemplate.'sections.'.$sec)
@endforeach
@endif
@endsection

@push('script-lib')
<script src="https://cdn.jsdelivr.net/jquery.webui-popover/1.2.1/jquery.webui-popover.min.js"></script>
@endpush

@push('script')
<script>
    $(document).ready(function() {
        $('.rental-popover').webuiPopover({
            url:'#rental-popover-content',
            width:400
        });
    })
</script>
@endpush