@extends($activeTemplate.'layouts.frontend')
@section('content')

@php
$banner = getContent('banner.content', true);
@endphp

@push('style-lib')
<link href="{{asset($activeTemplateTrue.'css/aos.css')}}" rel="stylesheet">
<link href="{{ asset('assets/common/css/sal.css') }}" rel="stylesheet">
@endpush

@push('style')
    <style>
      .banner-bg--img {
        background-image: url({{getImage(getFilePath('banner').'/'.@$banner->data_values->banner_image)}});
        background-repeat: no-repeat;
        /* background-size: cover; */
        background-size: 100vw 100vh;
      }
      @media screen and (max-width: 991px) {
        .banner-bg--img {
          background-size: cover;
        }
      }
    </style>
@endpush

<!--========================== Banner Section Start ==========================-->
<!-- bg-img -->
<section class="banner-section bg-img banner-bg--img">
    <div class="container">
        <div class="row gy-4 align-items-end">
            <div class="col-lg-6 col-md-6">
                  <div class="banner-left__content">
                      <h2>{!! ucfirst(nl2br(strip_tags($banner->data_values->heading, "<br>"))) !!}</h2>
                      <p>{!! nl2br(strip_tags($banner->data_values->sub_heading, "<br>")) !!}</p>
                  </div>
              </div>
        </div>
    </div>
  </section>
  <!--========================== Banner Section End ==========================-->

  @include($activeTemplate.'sections.new.counter')

  @include($activeTemplate.'sections.new.service')

  @include($activeTemplate.'sections.new.portfolio')

  @include($activeTemplate.'sections.new.testimonial')

  @include($activeTemplate.'sections.new.brand')


@if($sections->secs != null)
@foreach(json_decode($sections->secs) as $sec)
@include($activeTemplate.'sections.'.$sec)
@endforeach
@endif

@endsection

@section('content')

@push('script-lib')
<script src="{{asset($activeTemplateTrue.'js/aos.js')}}"></script>
<script src="{{ asset('assets/common/js/sal.js') }}"></script>
<script>
  sal({
    threshold: 0.5,
    once: true
  });

  AOS.init();
</script>
@endpush
