@extends($activeTemplate.'layouts.frontend')
@section('content')
@php
    $contact = getContent('contact_us.content',true);
    $socialIcons = getContent('social_icon.element',false);
@endphp
<!-- ==================== Contact Form Start Here ==================== -->
<section class="contact-bottom section-bg py-80">
    <div class="container">
        <div class="row gy-4 gx-4 justify-content-center">
        <div class="col-lg-6">
                <div class="contactus-form2">
                    <div class="row">
                        <div class="col-lg-8">
                            <h3 class="contact__title text-base">{{ $contact->data_values->title }}</h3>
                            <p class="text-base">{{ $contact->data_values->short_description }}</p>
                        </div>
                        <div class="col-lg-4">
                            <ul class="contact-social-list">
                                @foreach($socialIcons as $item)
                                <li class="contact-social-list__item"><a href="{{ __($item->data_values->url)}}" class="contact-social-list__link" target="_blank">@php echo $item->data_values->social_icon @endphp</a> </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    
                    <form class="mt-4" method="post" action="" class="verify-gcaptcha">
                        @csrf
                        <div class="row gy-md-4 gy-3">
                            <div class="col-sm-12">
                                <input name="name"  type="text" class="form--control" placeholder="Enter your name" autocomplete="off" value="{{ old('name') }}" required>
                            </div>
                            <div class="col-sm-12">
                                <input name="subject"  type="text" class="form--control" placeholder="Enter your subject" autocomplete="off" value="{{ old('subject') }}" required>
                            </div>
                            <div class="col-sm-12">
                                <input name="email" type="email" class="form--control" placeholder="Enter your email address" value="{{ old('email') }}" autocomplete="off" required>
                            </div>
                            <div class="col-sm-12">
                                <textarea class="form--control" placeholder="Go ahead, We are listening..." name="message">{{old('message')}}</textarea>
                            </div>
                            <x-captcha></x-captcha>
                            <div class="col-sm-12">
                                <button type="submit" class="btn btn-info w-100">
                                   @lang('Submit')<i class="ms-1 fas fa-paper-plane"></i>
                                    <span style="top: 249px; left: 75.9844px;"></span>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-lg-6">
                <div>
                    <iframe src="https://maps.google.com/maps?q={{ $contact->data_values->latitude }},{{ $contact->data_values->longitude }}&hl=es;z=14&amp;output=embed" width="100%" height="450" allowfullscreen="" loading="lazy"></iframe>
                </div>
                <div class="mt-5">
                    <ul class="contact-detail-ul">
                        <li>
                            <span class="contact-detail-ul__icon rounded-circle"><i class="fas fa-map-marker-alt"></i></span>
                            <span class="ms-4" style="position: relative;top: -5px;">{{__($contact->data_values->contact_details)}}</span>
                        </li>

                        <li>
                            <span class="contact-detail-ul__icon rounded-circle"><i class="fas fa-phone-alt"></i></span>
                            <span class="ms-4" style="position: relative;top: -5px;">{{__($contact->data_values->contact_number)}}</span>
                        </li>

                        <li>
                            <span class="contact-detail-ul__icon rounded-circle"><i class="fas fa-envelope"></i></span>
                            <span class="ms-4" style="position: relative;top: -5px;">{{__($contact->data_values->email_address)}}</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ==================== Contact Form End Here ==================== -->

@endsection
