@php
$contact = getContent('contact_us.content',true);
$socialIcons = getContent('social_icon.element',false);
$languages = App\Models\Language::all();
$pages = App\Models\Page::where('tempname',$activeTemplate)->where('is_show', 1)->orderBy('sort')->get();
@endphp
<!--========================== Header section Start ==========================-->
<div class="header-main-area">

    <div class="header-top">
        <div class="container-fluid">
            <div class="top-header-wrapper">
                <div class="top-contact">
                    <ul class="nav-logo-list">
                        <li class="nav-logo-list__item">
                            <div class="logo-wrapper">
                                <a href="{{route('home')}}" class="dark-logo "  > <img src="{{ getImage(getFilePath('logoIcon').'/logo_white.png', '?'
                                    .time()) }}" alt="{{config('app.name')}}"></a>
                            </div>
                        </li>
                    </ul>
                </div>

                <div class="top-contact">
                    <ul class="contact-list">
                        <li class="contact-list__item"> <span class="contact-list__item-icon"><i class="fas fa-envelope"></i></span><a href="mailto:{{__($contact->data_values->email_address)}}" class="contact-list__link"> {{__($contact->data_values->email_address)}}</a></li>
                        <li class="contact-list__item"> <span class="contact-list__item-icon"></span><a href="/career-center" class="btn btn--info btn--sm btn-career rounded-pill position-relative bg-base-light">
                            @lang('Career Center')
                            <!-- <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                0
                                <span class="visually-hidden">unread messages</span>
                            </span> -->

                        </a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="header" id="header">
        <div class="container-fluid position-relative">
            <div class="row">

                <!-- <div class="mobile-contact__wrapper position-relative">
                    <ul class="mobile-contact-list d-flex justify-content-end">
                        <li class="mobile-contact-list__item"><span class="mobile-contact-list__item-icon"><i class="fas fa-envelope"></i></span><a href="mailto:{{__($contact->data_values->email_address)}}" class="contact-list__link"> {{__($contact->data_values->email_address)}}</a></li>
                        <li class="mobile-contact-list__item"><a href="/career-center" class="btn btn--info btn--sm btn-career rounded-pill position-relative bg-base-light">
                            @lang('Career Center')
                        </a></li>
                    </ul>
                </div> -->

                <div class="header-wrapper">

                    <div class="logo-wrapper">

                            <a href="{{route('home')}}" class="normal-logo"> <img src="{{ getImage(getFilePath('logoIcon').'/logo_white.png', '?'
                                .time()) }}" alt="{{config('app.name')}}"></a>

                    </div>

                    <div class="mobile-contact__wrapper position-relative">
                        <ul class="mobile-contact-list d-flex justify-content-end">
                            <li class="mobile-contact-list__item"><span class="mobile-contact-list__item-icon"><i class="fas fa-envelope"></i></span><a href="mailto:{{__($contact->data_values->email_address)}}" class="contact-list__link"> {{__($contact->data_values->email_address)}}</a></li>
                            <li class="mobile-contact-list__item"><a href="/career-center" class="btn btn--info btn--sm btn-career rounded-pill position-relative bg-base-light">
                                @lang('Career Center')
                            </a></li>
                        </ul>
                    </div>

                    <div class="menu-wrapper">
                        <ul class="main-menu">
                            @foreach($pages as $page)
                            <li>
                                <a class="nav-link {{ Request::url() == url('/').'/'.$page->slug ? 'active' : '' }}" aria-current="page" href="{{route('pages',[$page->slug])}}">{{__($page->name)}}</a>
                            </li>
                            @endforeach
                        </ul>
                    </div>

                    <!-- TODO: Top Nav -->
                    <!-- <div class="top-info__wrapper_mobile">
                        <ul class="top-info__list">
                            <li class="top-info__list-item"> <span class="top-info__list-item-icon"><i class="fas fa-envelope"></i></span><a href="mailto:{{__($contact->data_values->email_address)}}" class="contact-list__link"> {{__($contact->data_values->email_address)}}</a></li>
                            <li class="top-info__list-item mt-2"> <span class="top-info__list-item-icon"></span><a href="/career-center" class="btn btn--info btn--sm btn-career rounded-pill position-relative bg-base-light">
                                @lang('Career Center')
                                <span class="position-absolute top-0 start-100 translate-middle p-2 bg-danger border border-light rounded-circle">
                                    <span class="visually-hidden">New alerts</span>
                                </span>
                            </a></li>
                        </ul>
                    </div> -->

                    <div class="menu-right-wrapper">
                        <ul>
                            <!-- <li class="menu-right__mobile_view"><a href="mailto:{{__($contact->data_values->email_address)}}" class="menu-right__mobile_view__link"> {{__($contact->data_values->email_address)}}</a></li>
                            <li class="menu-right__mobile_view">
                                <a href="/career-center" class="btn btn--info btn--sm btn-career rounded-pill position-relative bg-base-light">
                                    @lang('Career Center')
                                    <span class="position-absolute top-0 start-100 translate-middle p-2 bg-danger border border-light rounded-circle">
                                        <span class="visually-hidden">New alerts</span>
                                    </span>
                                </a>
                            </li> -->
                            <li class="toggle-icon"><i class="fas fa-bars sidebar-menu-show-hide"></i></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<!--========================== Header section End ==========================-->


<!--========================== Sidebar mobile menu wrap Start ==========================-->
<div class="sidebar-menu-wrapper">
    <div class="top-close d-flex align-items-center justify-content-between">
        <div class="header-wrapper">

            <div class="logo-wrapper mb-1">
                <a href="{{route('home')}}" class="dark-logo" > <img src="{{ getImage(getFilePath('logoIcon').'/logo.png', '?'
                    .time()) }}" alt="{{config('app.name')}}"></a>
            </div>
        </div>
        <i class="fas fa-times close-hide-show"></i>
    </div>
    <hr>
    <ul class="sidebar-menu-list">
        @foreach($pages as $page)
        <li class="sidebar-menu-list__item {{ Request::url() == url('/').'/'.$page->slug ? 'active' : '' }}">
            <a href="{{route('pages',[$page->slug])}}" class="sidebar-menu-list__link">{{__($page->name)}}</a>
        </li>
        @endforeach
    </ul>
</div>
<!--========================== Sidebar mobile menu wrap End ==========================-->
