@php
$links = getContent('policy_pages.element');
$importantLinks = getContent('footer_important_links.element', false);
$companyLinks = getContent('footer_company_links.element', false, null, true);
$subscribe = getContent('subscribe.content', true);
$contact = getContent('contact_us.content',true);
$socialIcons = getContent('social_icon.element',false);
@endphp
<!-- ==================== Footer Start Here ==================== -->
<footer class="footer-area">
    <div class="pb-60 pt-90">
        <div class="container">
            <div class="row justify-content-center gy-5">
                <div class="col-xl-3 col-sm-6 col-3">
                    <div class="footer-item">

                        <div class="footer-item__logo">
                            <a href="{{route('home')}}" class="footer-logo-normal" id="footer-logo-normal"> <img src="{{ getImage(getFilePath('logoIcon').'/logo_white.png', '?'
                                .time()) }}" alt="{{config('app.name')}}"></a>
                        </div>
                        
                    </div>
                </div>

                <!-- <div class="col-xl-3 col-sm-6 col-3">

                </div> -->

                <div class="col-xl-3 col-sm-6 col-5">
                    <div class="footer-item">
                        <ul class="footer-menu">
                            @foreach($importantLinks as $link)
                            <li class="footer-menu__item"><a href="{{url('/').$link->data_values->url}}" class="footer-menu__link">{{$link->data_values->title}}</a></li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-4">
                    <div class="footer-item">

                        <p class="footer-item__desc">
                            {{__($contact->data_values->email_address)}}
                        </p>

                        <p class="footer-item__desc mb-3">
                            {{__($contact->data_values->contact_number)}} (Telegram)
                        </p>

                        <ul class="social-list">
                            @foreach($socialIcons as $item)
                            <li class="social-list__item"><a href="{{ __($item->data_values->url)}}" class="social-list__link" target="_blank">@php echo $item->data_values->social_icon @endphp</a> </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
  <!-- Footer Top End-->

    <!-- bottom Footer -->
    <div class="bottom-footer section-bg py-3">
        <div class="container">
            <div class="row gy-2">
                <div class="col-lg-12 col-md-12">
                    <div class="bottom-footer-text text-center">@php echo $contact->data_values->website_footer @endphp</div>
                </div>
            </div>
        </div>
    </div>
  </footer>
  <!-- ==================== Footer End Here ==================== -->
