@extends($activeTemplate.'layouts.frontend')
@section('content')
<!-- ==================== Service Start Here ==================== -->
<section class="service-area section-bg py-80 ">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-lg-12">
                <h3 class="text-center fw-bold text-base">{{__('Career Center')}}</h3>
            </div>
        </div>

        <!-- TODO: Listing -->
        <div class="career-wrapper row gy-4">
            <div class="col-12 career-filters">
                <div class="d-flex bd-highlight mb-3">
                    <div class="p-2 bd-highlight">
                        <a href="{{ route('career_center') }}" class="bg-info rounded px-5 py-2">{{ __('All') }}</a>
                    </div>
                    <div class="p-2 bd-highlight">
                        <a href="{{ route('career_center') }}?prestige=1" class="{{ request()->get('prestige')==1 ? 'bg-primary':'bg-base' }} rounded px-5 py-2">
                            <img src="{{ asset('assets/images/frontend/others/prestige-icon.png') }}">
                            {{ __('Prestige') }}
                        </a>
                    </div>
                    <div class="ms-auto p-2 bd-highlight">
                        <a href="{{ route('career_center') }}" class="bg-info rounded px-4 py-2">{{ __('Latest') }}</a>
                    </div>
                </div>
            </div>
            <div class="col-12">
                @foreach ($rows as $item)
                <div class="career-item d-flex justify-content-between bd-highlight mb-3 rounded bg-white p-4">
                    <div class="me-auto p-2 bd-highlight">
                        <h4 class="mb-5"><a class="text-base" href="{{ route('career_center.details', $item->uuid) }}">{{ $item->title }}</a></h4>
                        <p class="text-base">Experience: <strong>{{ number_format($item->experience_min) }}-{{ number_format($item->experience_max) }} years</strong></p>
                        <p class="text-base">Deadline: <strong>{{ \Carbon\Carbon::parse($item->date)->format('d/m/Y') }}</strong></p>
                    </div>
                    <div class="p-2 bd-highlight">
                        @if ($item->is_urgent)
                        <div class="career-item__urgent float-end">
                            <span class="bg-info px-5 py-3 text-white rounded fw-bold">Urgent</span>
                        </div>
                        <div class="clearfix"></div>
                        @endif
                        <p class="text-base mt-5">Company Type: <strong>{{ $item->company_type }}</strong></p>
                        <p class="text-base">Location: <strong>{{ $item->location }}</strong></p>
                    </div>
                </div>
                @endforeach
            </div>
            <div class="col-sm-12">
                <nav>
                    <ul class="pagination mt-3">
                        @if ($rows->hasPages())
                        <div class="py-4">
                            {{ paginateLinks($rows) }}
                        </div>
                        @endif
                    </ul>
                </nav>
            </div>
        </div>
    </div>
</section>
<!-- ==================== Service End Here ==================== -->

@if($sections->secs != null)
@foreach(json_decode($sections->secs) as $sec)
@include($activeTemplate.'sections.'.$sec)
@endforeach
@endif
@endsection
