@php
$socialIcons = getContent('social_icon.element',false);
@endphp

@extends($activeTemplate.'layouts.frontend')
@section('content')
<!-- ==================== Item Start Here ==================== -->
<section class="blog-detials py-60">
    <div class="container">
        <div class="row gy-5 justify-content-center">
            <div class="col-lg-4">
                <div class="p-5 rounded mb-5 bg-white">
                    <h5 class="text-base mb-2">{{__($career->title)}}</h5>
                    <p class="text-base mt-3">Experience: <strong>{{ number_format($career->experience_min) }}-{{ number_format($career->experience_max) }} years</strong></p>
                    <p class="text-base mt-3">Deadline: <strong>{{ \Carbon\Carbon::parse($career->date)->format('d/m/Y') }}</strong></p>
                    <p class="text-base mt-3">Company Type: <strong>{{ $career->company_type }}</strong></p>
                    <p class="text-base mt-3">Location: <strong>{{ $career->location }}</strong></p>

                    <div class="mt-5">
                        <ul class="career-social-list">
                            @foreach($socialIcons as $item)
                            <li class="career-social-list__item"><a href="{{ __($item->data_values->url)}}" class="career-social-list__link" target="_blank">@php echo $item->data_values->social_icon @endphp</a> </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="p-5 rounded mb-5 bg-white">
                    <h5 class="text-base mb-2">{{__('Requirement')}}</h5>
                    <div class="ckeditor-content">
                        {!! $career->requirement !!}
                    </div>

                    <h5 class="text-base mt-5 mb-2">{{__('Details')}}</h5>
                    <p class="text-base mt-3">Experience: <strong>{{ number_format($career->experience_min) }}-{{ number_format($career->experience_max) }} years</strong></p>
                    <p class="text-base mt-3">Deadline: <strong>{{ \Carbon\Carbon::parse($career->date)->format('d/m/Y') }}</strong></p>

                    <a href="{{ $career->apply_url }}" target="_blank" class="btn btn-info mt-5">Apply Now</a>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ==================== report-inside End Here ==================== -->
@endsection

@push('style')
<style>
.ckeditor-content p {
    margin-bottom: 1rem;
}

.ckeditor-content strong {
    font-weight: bold;
}

.ckeditor-content u {
    text-decoration: underline;
}

.ckeditor-content i {
    font-style: italic;
}

/* Table styling */
.ckeditor-content table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 1rem;
}

.ckeditor-content td {
    border: 1px solid #ccc;
    padding: 8px;
}

/* Ordered and Unordered lists */
.ckeditor-content ul,
.ckeditor-content ol {
    list-style-type: revert !important; /* Ensures browser default is restored */
    margin-left: 1.5rem;
    padding-left: 1.5rem;
}

.ckeditor-content li {
    display: list-item !important;
    list-style-type: revert !important;
}

/* Link styling */
.ckeditor-content a {
    color: #007bff;
    text-decoration: underline;
}

.ckeditor-content a:hover {
    text-decoration: none;
}
</style>

@endpush

