@extends($activeTemplate.'layouts.frontend')

@section('content')
<!-- ==================== Service Start Here ==================== -->
<section class="service-area section-bg py-80 blog-area">
    <div class="container">

        @if ((request()->get('page') == 1 || !request()->get('page')) && $featuredBlog)
        <div class="row">
            <div class="col-12 col-md-8">
                <img src="{{getImage(getFilePath('blog').'/'.$featuredBlog->featured_image)}}" alt="{{ $featuredBlog->title }}" class="rounded w-100 mb-2">
            </div>
            <div class="col-12 col-md-4 ps-5">
                <h5><a href="{{ route('blog.details', $featuredBlog->slug) }}" class="text-base">{{ $featuredBlog->title }}</a></h5>
                <p class="mt-5">{{ \Str::limit(strip_tags(html_entity_decode($featuredBlog->description)), 500) }}</p>
            </div>
        </div>
        <hr class="mt-5">
        @endif

        <div class="row mt-4">
            <div class="col-md-12">
                <div class="blog-grid">
                @foreach ($blogs as $item)

                    @php
                    $truncated_title = \Str::limit(strip_tags(html_entity_decode($item->title)), 80, '...');
                    @endphp

                    <div class="blog-post">
                        <div class="image-container">
                            <img src="{{getImage(getFilePath('blog').'/'.$item->featured_image)}}" alt="{{ $item->title }}">
                        </div>
                        <div class="card-body">
                            <h5 class="card-title"><a href="{{ route('blog.details', $item->slug) }}" class="text-base">{{ $truncated_title }}</a></h5>
                            <small class="post-date">{{ date('d M Y', strtotime($item->created_at)) }}</small>
                        </div>
                    </div>
                @endforeach
                </div>
            </div>
            <div class="col-md-12">
                <nav>
                    <ul class="pagination mt-3">
                        @if ($blogs->hasPages())
                        <div class="py-4">
                            {{ paginateLinks($blogs) }}
                        </div>
                        @endif
                    </ul>
                </nav>
            </div>
        </div>
    </div>
</section>
<!-- ==================== Service End Here ==================== -->

@if($sections->secs != null)
@foreach(json_decode($sections->secs) as $sec)
@include($activeTemplate.'sections.'.$sec)
@endforeach
@endif
@endsection
