@extends($activeTemplate.'layouts.frontend')
@section('content')
<!-- ==================== Item Start Here ==================== -->
<section class="blog-detials py-60">
    <div class="container">
        <div class="row gy-5 justify-content-center">
            <div class="col-lg-12">
                <div class="blog-details" style="border-radius: 0">
                   <div class="blog-details__content">
                        <h3 class="blog-details__title text-base fw-bold">{{__($blog->title)}}</h3>
                        <p class="blog-details__desc wyg">
                            @php
                               echo $blog->description;
                            @endphp
                        </p>
                   </div>
                </div>
            </div>

            <!-- Related Article -->
            <div class="col-lg-12 mb-4 blog-area">
                <h4 class="text-base">Relate Article</h4>
                <hr>
                <div class="blog-grid">
                    @if ($related_articles)
                        @foreach($related_articles as $related)
                            @php
                            $truncated_title = \Str::limit(strip_tags(html_entity_decode($related->title)), 80, '...');
                            @endphp

                            <div class="blog-post">
                                <div class="image-container">
                                    <img src="{{getImage(getFilePath('blog').'/'.$related->featured_image)}}" alt="{{ $related->title }}">
                                </div>
                                <div class="card-body">
                                    <h5 class="card-title"><a href="{{ route('blog.details', $related->slug) }}" class="text-base">{{ $truncated_title }}</a></h5>
                                    <small class="post-date">{{ date('d M Y', strtotime($related->created_at)) }}</small>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ==================== report-inside End Here ==================== -->
@endsection

@push('style')
    <style>
        .wyg h1,
        .wyg h2,
        .wyg h3,
        .wyg h4 {
            color: hsl(var(--black));
        }

        .wyg p {
            color: hsl(var(--black));
        }

        .wyg ul {
            margin: 35px;
        }

        .wyg ul li {
            list-style-type: disc;
            color: hsl(var(--black));
            font-family: var(--body-font);
        }

        /*========= dark css =======*/
        .dark .wyg h1,
        .dark .wyg h2,
        .dark .wyg h3,
        .dark .wyg h4 {
            color: hsl(var(--white));
        }

        .dark .wyg p {
            color: hsl(var(--white));
        }

        .dark .wyg ul {
            margin: 35px;
        }

        .dark .wyg ul li {
            list-style-type: disc;
            color: hsl(var(--white));
        }

        .blog-detials p a {
            color: #0d6efd !important;
            text-decoration: underline !important;
        }
    </style>
@endpush

