@php
    // Display page view count badge for the current page path.
    try {
        $currentPath = parse_url(request()->getRequestUri(), PHP_URL_PATH) ?: '/';
        $pv = \App\Models\PageView::where('path', $currentPath)->first();
        // try alternate normalization (trim trailing slash)
        if (!$pv) {
            $alt = rtrim($currentPath, '/');
            if ($alt === '') $alt = '/';
            $pv = \App\Models\PageView::where('path', $alt)->first();
        }
        $views = $pv ? (int) $pv->views : 0;
    } catch (\Exception $e) {
        $views = 0;
    }
@endphp

<div class="page-view-badge" style="position:fixed; right:18px; bottom:18px; z-index:1200">
    <div style="background:#00a7a7;color:#fff;padding:10px 14px;border-radius:20px;box-shadow:0 10px 30px rgba(0,0,0,0.12);font-weight:700">
        <span style="font-size:13px;display:block;line-height:1">Views</span>
        <span style="font-size:16px">{{ number_format($views) }}</span>
    </div>
</div>
