@php
    $ga = config('services.google_analytics', []);
    $enabled = data_get($ga, 'enabled');
    $measurementId = data_get($ga, 'measurement_id');
@endphp

@if($enabled && $measurementId && \Illuminate\Support\Str::startsWith($measurementId, 'G-'))
<!-- Google Analytics (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id={{ $measurementId }}"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  if (!window.__gtag_configured) {
      gtag('config', '{{ $measurementId }}', { 'send_page_view': true });
      window.__gtag_configured = true;
  }
</script>
@endif
