@if($seo)
    <meta name="title" content="{{ $pageTitle ?? $general->siteName(__($pageTitle)) }}">
    <meta name="description" content="{{ $seo->description }}">
    <meta name="keywords" content="{{ implode(',',$seo->keywords) }}">
    <link rel="shortcut icon" href="{{ getImage(getFilePath('logoIcon') .'/favicon.png') }}" type="image/x-icon">

    <meta name="author" content="{{config('app.name')}}">

    {{--<!-- Apple Stuff -->--}}
    <link rel="apple-touch-icon" href="{{ getImage(getFilePath('logoIcon') .'/favicon.png') }}">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="{{ $general->siteName($pageTitle) }}">
    {{--<!-- Google / Search Engine Tags -->--}}
    <meta itemprop="name" content="{{ $general->siteName($pageTitle) }}">
    <meta itemprop="description" content="{{ $pageDescription ?? $general->seo_description }}">
    <meta itemprop="image" content="{{ $pageImage ?? getImage(getFilePath('seo') .'/'. $seo->image) }}">
    {{--<!-- Facebook Meta Tags -->--}}
    <meta property="og:type" content="article">
    <meta property="og:title" content="{{ $general->siteName($pageTitle) }}">
    <meta property="og:description" content="{{ $pageDescription ?? $seo->social_description }}">
    <meta property="og:image" content="{{ $pageImage ?? getImage(getFilePath('seo') .'/'. $seo->image) }}">
    <meta property="og:image:type" content="image/{{ pathinfo($pageImage ?? getImage(getFilePath('seo')) .'/'. $seo->image)['extension'] }}">
    @php $socialImageSize = explode('x', getFileSize('seo')) @endphp
    <meta property="og:image:width" content="{{ $socialImageSize[0] }}">
    <meta property="og:image:height" content="{{ $socialImageSize[1] }}">
    <meta property="og:url" content="{{ url()->current() }}">
    {{--<!-- Twitter Meta Tags -->--}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $general->siteName($pageTitle) }}">
    <meta name="twitter:description" content="{{ $pageDescription ?? $seo->social_description }}">
    <meta name="twitter:image" content="{{ $pageImage ?? getImage(getFilePath('seo') .'/'. $seo->image) }}">
@endif
