<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Report Download</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: #1e3a8a;
            color: white;
            padding: 30px;
            text-align: center;
            border-radius: 8px 8px 0 0;
        }
        .content {
            background: #f8f9fa;
            padding: 30px;
            border-radius: 0 0 8px 8px;
        }
        .info-table {
            width: 100%;
            margin: 20px 0;
            background: white;
            border-radius: 6px;
            overflow: hidden;
        }
        .info-table tr {
            border-bottom: 1px solid #e5e7eb;
        }
        .info-table tr:last-child {
            border-bottom: none;
        }
        .info-table td {
            padding: 12px 15px;
        }
        .info-table td:first-child {
            font-weight: bold;
            width: 40%;
            background: #f3f4f6;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>📊 New Report Download</h1>
    </div>

    <div class="content">
        <p>A new report has been downloaded from the website.</p>

        <table class="info-table">
            <tr>
                <td>Report Title</td>
                <td><strong>{{ $report_title }}</strong></td>
            </tr>
            <tr>
                <td>First Name</td>
                <td>{{ $first_name }}</td>
            </tr>
            <tr>
                <td>Last Name</td>
                <td>{{ $last_name }}</td>
            </tr>
            <tr>
                <td>Email</td>
                <td><a href="mailto:{{ $email }}">{{ $email }}</a></td>
            </tr>
            <tr>
                <td>Downloaded At</td>
                <td>{{ $downloaded_at }}</td>
            </tr>
        </table>

        <p style="color: #666; font-size: 14px; margin-top: 20px;">
            This is an automated notification from the Prestige Alliance website.
        </p>
    </div>
</body>
</html>
