@extends('admin.layouts.app')

@section('panel')
@include('admin.components.tabs.ticket')
<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light">
                        <thead>
                            <tr>
                                <th>@lang('Opened By')</th>
                                <th>@lang('Subject')</th>
                                <th>@lang('Message')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Date')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($items as $item)
                            <tr>
                                <td>
                                    @if($item->user_id)
                                    <a href="{{ route('admin.users.detail', $item->user_id) }}">
                                        {{@$item->user->fullname}}</a>
                                    @else
                                    <p class="fw-bold"> {{$item->name}}</p>
                                    @endif
                                    <br>
                                    <p class="fw-bold fst-italic"> {{$item->email}}</p>
                                </td>
                                <td>
                                    <a href="{{ route('admin.ticket.view', $item->id) }}" class="fw-bold text--muted">
                                        @lang('Ticket')#{{ $item->ticket }} - {{ strLimit($item->subject,30) }} </a>
                                </td>

                                <td>
                                    @if($item->supportMessageOne)
                                    {{ $item->supportMessageOne->message }}
                                    @endif
                                </td>
                                <td>
                                    @php echo $item->statusBadge; @endphp
                                </td>
                                <td>
                                    {{ $item->created_at }}
                                </td>
                                <td>
                                    <a title="@lang('Details')" href="{{ route('admin.ticket.view', $item->id) }}"
                                        class="btn btn-sm btn--primary ms-1">
                                        <i class="las la-eye text--shadow"></i>
                                    </a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                            </tr>
                            @endforelse

                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            @if ($items->hasPages())
            <div class="card-footer py-4">
                {{ paginateLinks($items) }}
            </div>
            @endif
        </div><!-- card end -->
    </div>
</div>
@endsection