@extends('admin.layouts.app')

@section('panel')
<div class="card">
    <div class="card-body">
        <!-- ======================= SEARCH UI ======================= -->
        <div class="d-flex justify-content-between align-items-center mb-4">

            <form method="GET"
                  action="{{ route('admin.reportdownloads.index') }}"
                  class="search-form d-flex align-items-center"
                  style="width: 350px;">

                <div class="input-group">
                    <input type="text"
                           name="search"
                           id="searchInput"
                           class="form-control"
                           placeholder="Search Options..."
                           value="{{ request('search') }}">

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i>
                    </button>
                </div>

            </form>

        </div>
        <!-- ======================= END SEARCH UI ======================= -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <span class="total-badge">
                Total Downloads: <strong>{{ $totalDownloads }}</strong>
            </span>
        </div>

        <!-- ======================= TABLE ======================= -->
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th width="60">ID</th>
                        <th>Report</th>
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th>Email</th>
                        <th width="200">Download Link</th>
                        <th width="180">Downloaded At</th>
                    </tr>
                </thead>

                <tbody>
                    @forelse($downloads as $download)
                    <tr>
                        <td><span class="id-badge">{{ $loop->iteration + ($downloads->currentPage()-1) * $downloads->perPage() }}</span></td>

                        <td>{{ optional($download->report)->title ?? '-' }}</td>

                        <td><strong>{{ $download->first_name }}</strong></td>

                        <td><strong>{{ $download->last_name }}</strong></td>

                        <td class="email-cell">{{ $download->email }}</td>

                        <td>
                            @php
                                // Prefer the snapshot fields stored on the download row.
                                $file = $download->download_report_file ?? optional($download->report)->download_report_file;
                                $external = $download->download_report_external_url ?? optional($download->report)->download_report_external_url;
                            @endphp

                            @if($external && $file)
                                <a href="{{ $external }}"
                                   target="_blank"
                                   class="btn btn-sm btn-info">
                                    <i class="fas fa-external-link-alt"></i> External Link
                                </a>
                                <a href="{{ asset(getFilePath('reportInsideImage').'/'.$file) }}"
                                   target="_blank"
                                   class="btn btn-sm btn-primary ml-2">
                                    <i class="fas fa-file-pdf"></i> View PDF
                                </a>
                            @elseif($external)
                                <a href="{{ $external }}"
                                   target="_blank"
                                   class="btn btn-sm btn-info">
                                    <i class="fas fa-external-link-alt"></i> External Link
                                </a>
                            @elseif($file)
                                <a href="{{ asset(getFilePath('reportInsideImage').'/'.$file) }}"
                                   target="_blank"
                                   class="btn btn-sm btn-primary">
                                    <i class="fas fa-file-pdf"></i> View PDF
                                </a>
                            @elseif($download->report)
                                <span class="text-muted">No file</span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>

                        <td class="date-cell">{{ showDateTime($download->created_at) }}</td>
                    </tr>

                    @empty
                    <tr>
                        <td colspan="6" class="text-center py-5 text-muted">
                            <i class="fas fa-folder-open fa-2x mb-2"></i><br>
                            No downloads found.
                        </td>
                    </tr>
                    @endforelse
                </tbody>

            </table>
        </div>

        <!-- ======================= PAGINATION ======================= -->
        <div class="mt-3">
            {{ $downloads->links() }}
        </div>

    </div>
</div>

<!-- ======================= AUTO RESET SEARCH WHEN EMPTY ======================= -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    const searchInput = document.getElementById("searchInput");

    if (!searchInput) return;

    searchInput.addEventListener("input", function () {
        if (this.value.trim() === "") {
            window.location = "{{ route('admin.reportdownloads.index') }}";
        }
    });
});
</script>
@endsection
