@extends('admin.layouts.app')
@section('panel')

<div class="row mb-none-30">
    <div class="col-lg-12 mb-30">
        <div class="card">
            <div class="card-body">
                <form action="{{route('admin.officeandeventspace.slide.update',$slide->id)}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="image" class="font-weight-bold">@lang('Image')</label>
                                <div class="file-upload-wrapper" data-text="Select your image!">
                                    <input type="file" name="image" id="image" class="file-upload-field">
                                </div>
                            </div>
                        </div>
                    
                        <div class="col-lg-3">
                            <div class="form-group">
                                <label for="status" class="font-weight-bold">@lang('Status')</label>
                                <select name="status" id="status" class="form-control " required>
                                    <option value="0" {{ $slide->status==0 ? 'selected': '' }}>@lang('Inactive')</option>
                                    <option value="1" {{ $slide->status==1 ? 'selected': '' }}>@lang('Active')</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-lg-12">
                                <h5 class="font-weight-bold">@lang('Old Image')</h5>
                                <img src="{{getImage(getFilePath('uploads').'/'.$slide->image)}}" class="rounded" alt="image"   style="width:300px;">
                        </div>

                        <div class="row text-end">
                            <div class="col-lg-12 ">
                                <div class="form-group float-end p-3">
                                    <button type="submit" class="btn btn--primary btn-block btn-lg"> @lang('Update')</button>
                                </div>
                            </div>
                        </div>
                 </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('breadcrumb-plugins')
<a href="{{route('admin.officeandeventspace.slide.index')}}" class="btn btn-sm btn--primary box--shadow1 text--small"><i
        class="las la-angle-double-left"></i>@lang('Go Back')</a>
@endpush


@push('style')
<style>
    .ck-placeholder{
        height: 190px !important;
    }
</style>
@endpush




