@extends('admin.layouts.app')
@section('panel')

<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-header fw-bold">
                @lang('Office Space Rate')
            </div>
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th>@lang('Type')</th>
                                <th>@lang('Room')</th>
                                <th>@lang('Floor')</th>
                                <th>@lang('Size (m)')</th>
                                <th>@lang('Additional Space')</th>
                                <th>@lang('Amenities')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($officeSpaces as $office)
                            <tr>
                                <td>{{ $office->type }}</td>
                                <td>{{ $office->room }}</td>
                                <td>{{ $office->floor }}</td>
                                <td>{{ $office->size }}</td>
                                <td>{{ $office->additional_space }}</td>
                                <td>{{ $office->amenities }}</td>
                                <td>
                                    @php
                                        echo $office->statusBadge($office->status);
                                    @endphp
                                </td>
                                <td>
                                    <a href="{{route('admin.officeandeventspace.edit',$office->id)}}" title="@lang('Edit')" class="btn btn-sm btn--primary updateService ">
                                        <i class="las la-edit"></i>
                                    </a>
                                    <button title="@lang('Remove')"
                                     data-id="{{$office->id}}"
                                        class="btn btn-sm btn--danger rejectBtn">
                                        <i class="las la-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                            </tr>
                            @endforelse

                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
        </div><!-- card end -->
    </div>
</div>

<hr class="mt-5">

<div class="row mt-5">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-header fw-bold">
                @lang('Event Space Rate')
            </div>
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th>@lang('Type')</th>
                                <th>@lang('Room')</th>
                                <th>@lang('Floor')</th>
                                <th>@lang('Size (m)')</th>
                                <th>@lang('Additional Space')</th>
                                <th>@lang('Amenities')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($eventSpaces as $event)
                            <tr>
                                <td>{{ $event->type }}</td>
                                <td>{{ $event->room }}</td>
                                <td>{{ $event->floor }}</td>
                                <td>{{ $event->size }}</td>
                                <td>{{ $event->additional_space }}</td>
                                <td>{{ $event->amenities }}</td>
                                <td>
                                    @php
                                        echo $event->statusBadge($event->status);
                                    @endphp
                                </td>


                                <td>
                                    <a href="{{route('admin.officeandeventspace.edit',$event->id)}}" title="@lang('Edit')" class="btn btn-sm btn--primary updateService ">
                                        <i class="las la-edit"></i>
                                    </a>
                                    <button title="@lang('Remove')"
                                     data-id="{{$event->id}}"
                                        class="btn btn-sm btn--danger rejectBtn">
                                        <i class="las la-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                            </tr>
                            @endforelse

                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
        </div><!-- card end -->
    </div>
</div>


{{-- delete modal --}}
<div id="rejectModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Delete Office and Event Space Confirmation')</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="{{route('admin.officeandeventspace.delete')}}" method="POST">
                @csrf
                <input type="hidden" name="id">
                <div class="modal-body">
                    <p>@lang('Are you sure to') <span class="fw-bold">@lang('delete')</span> <span
                            class="fw-bold withdraw-amount text-success"></span> @lang('this office and event space') <span
                            class="fw-bold withdraw-user"></span>?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--danger btn-global">@lang('Delete')</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('breadcrumb-plugins')
<a href="{{route('admin.officeandeventspace.create')}}"  class="btn btn-sm btn--primary">
    @lang('Add Office and Event Space')</a>
@endpush

@push('script')
<script>
      (function($){
        "use strict";

    $('.rejectBtn').on('click', function () {
            var modal = $('#rejectModal');
            modal.find('input[name=id]').val($(this).data('id'));
            modal.modal('show');
        });

    })(jQuery);
</script>
@endpush

