@extends('admin.layouts.app')
@section('panel')

<div class="row mb-none-30">
    <div class="col-lg-12 mb-30">
        <div class="card">
            <div class="card-body">
                <form action="{{route('admin.officeandeventspace.update',$row->id)}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                    <div class="col-lg-3">
                            <div class="form-group">
                                <label for="type" class="font-weight-bold">@lang('Type')</label>
                                <select name="type" id="type" class="form-control " required>
                                    <option value="Office" {{ $row->type=='Office' ? 'selected': '' }}>@lang('Office')</option>
                                    <option value="Event" {{ $row->type=='Event' ? 'selected': '' }}>@lang('Event')</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-lg-3">
                            <div class="form-group">
                                <label for="room" class="font-weight-bold">@lang('Room')</label>
                                <input type="text" name="room" id="room" value="{{old('room')??$row->room}}"
                                    class="form-control " placeholder="@lang('Room')" required>
                            </div>
                        </div>

                        <div class="col-lg-3">
                            <div class="form-group">
                                <label for="floor" class="font-weight-bold">@lang('Floor')</label>
                                <input type="text" name="floor" id="floor" value="{{old('floor')??$row->floor}}"
                                    class="form-control " placeholder="@lang('Floor')">
                            </div>
                        </div>

                        <div class="col-lg-3">
                            <div class="form-group">
                                <label for="size" class="font-weight-bold">@lang('Size (m)')</label>
                                <input type="text" name="size" id="size" value="{{old('size')??$row->size}}"
                                    class="form-control " placeholder="@lang('Size (m)')">
                            </div>
                        </div>

                        <div class="col-lg-3">
                            <div class="form-group">
                                <label for="additional_space" class="font-weight-bold">@lang('Additional Space')</label>
                                <input type="text" name="additional_space" id="additional_space" value="{{old('additional_space')??$row->additional_space}}"
                                    class="form-control " placeholder="@lang('Additional Space')">
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="amenities" class="font-weight-bold">@lang('Amenities')</label>
                                <input type="text" name="amenities" id="amenities" value="{{old('amenities')??$row->amenities}}"
                                    class="form-control " placeholder="@lang('Amenities')">
                            </div>
                        </div>

                        <div class="col-lg-3">
                            <div class="form-group">
                                <label for="status" class="font-weight-bold">@lang('Status')</label>
                                <select name="status" id="status" class="form-control " required>
                                    <option value="0" {{ $row->status==0 ? 'selected': '' }}>@lang('Inactive')</option>
                                    <option value="1" {{ $row->status==1 ? 'selected': '' }}>@lang('Active')</option>
                                </select>
                            </div>
                        </div>

                        <div class="row text-end">
                            <div class="col-lg-12 ">
                                <div class="form-group float-end p-3">
                                    <button type="submit" class="btn btn--primary btn-block btn-lg"> @lang('Update')</button>
                                </div>
                            </div>
                        </div>
                 </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('breadcrumb-plugins')
<a href="{{route('admin.officeandeventspace.index')}}" class="btn btn-sm btn--primary box--shadow1 text--small"><i
        class="las la-angle-double-left"></i>@lang('Go Back')</a>
@endpush


@push('style')
<style>
    .ck-placeholder{
        height: 190px !important;
    }
</style>
@endpush




