@extends('admin.layouts.app')

@section('panel')

@if(@json_decode($general->system_info)->message)
<div class="row">
    @foreach(json_decode($general->system_info)->message as $msg)
    <div class="col-md-12">
        <div class="alert border border--primary alert-dismissible d-flex align-items-center" role="alert">
            <div class="alert__icon bg--primary me-3"><i class="far fa-bell"></i></div>
            <div class="flex-fill">
                <p class="alert__message mb-0">@php echo $msg; @endphp</p>
            </div>
            <button type="button" class="btn-close ms-3" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    </div>
    @endforeach
</div>
@endif

<!-- ========================= -->
<!-- Dashboard Header + Filter -->
<!-- ========================= -->

<div class="dashboard-header mb-4">
    <h3 class="mb-1">@lang('Dashboard')</h3>
    <form id="dashboard-filter-form" method="get" action="{{ route('admin.dashboard') }}" class="row g-3 align-items-end">
        <div class="col-md-3">
            <label class="form-label">Range</label>
            <select name="range" id="dashboard-range" class="form-select">
                <option value="" {{ empty($selectedRange) ? 'selected' : '' }}>All Time</option>
                <option value="today" {{ ($selectedRange == 'today') ? 'selected' : '' }}>Today</option>
                <option value="week" {{ ($selectedRange == 'week') ? 'selected' : '' }}>This Week</option>
                <option value="month" {{ ($selectedRange == 'month') ? 'selected' : '' }}>This Month</option>
                <option value="year" {{ ($selectedRange == 'year') ? 'selected' : '' }}>This Year</option>
                <option value="custom" {{ ($selectedRange == 'custom') ? 'selected' : '' }}>Custom</option>
            </select>
        </div>

        <div class="col-md-4 custom-dates" style="display: {{ ($selectedRange == 'custom') ? 'flex' : 'none' }}; gap:12px;">
            <div class="flex-fill">
                <label class="form-label">From</label>
                <input type="date" name="from" class="form-control" value="{{ $selectedFrom ?? '' }}">
            </div>
            <div class="flex-fill">
                <label class="form-label">To</label>
                <input type="date" name="to" class="form-control" value="{{ $selectedTo ?? '' }}">
            </div>
        </div>

        <div class="col-md-2">
            <button type="submit" class="btn btn--primary w-100">Apply</button>
        </div>

        <div class="col-md-2">
            <a href="{{ route('admin.dashboard') }}" class="btn btn--danger w-100">Reset</a>
        </div>
    </form>
</div>


<!-- ========================= -->
<!--   TOP STAT CARDS         -->
<!-- ========================= -->

<div class="row g-3 mb-4">

    <div class="col-sm-6 col-md-3">
        <div class="card h-100 shadow-sm">
            <div class="card-body">
                <h6 class="mb-1">Page Views</h6>
                    <h3 class="fw-bold">{{ $pageViews ?? $widget['total_users'] }}</h3>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-3">
        <a href="{{route('admin.plan.index')}}">
            <div class="card h-100 shadow-sm bg--primary text-white">
                <div class="card-body">
                    <h6 class="mb-1 text-white">Total Portfolio</h6>
                    <h3 class="fw-bold text-white">{{__($totalPortfolio)}}</h3>
                </div>
            </div>
        </a>
    </div>

    <div class="col-sm-6 col-md-3">
        <a href="{{route('admin.service.index')}}">
            <div class="card h-100 shadow-sm">
                <div class="card-body">
                    <h6 class="mb-1">Total Services</h6>
                    <h3 class="fw-bold">{{__($totalService)}}</h3>
                </div>
            </div>
        </a>
    </div>

    <div class="col-sm-6 col-md-3">
        <a href="{{route('admin.reportdownloads.index')}}">
            <div class="card h-100 shadow-sm bg--primary text-white">
                <div class="card-body">
                    <h6 class="mb-1 text-white">Total Downloads</h6>
                    <h3 class="fw-bold text-white">{{__($totalDownloads)}}</h3>
                </div>
            </div>
        </a>
    </div>

</div>

<div class="card shadow-sm mb-4">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="card-title mb-0">Recent Tickets</h5>
            <a href="{{route('admin.ticket.pending')}}" target="_blank" class="text-primary">View all</a>
        </div>

        <div class="table-responsive">
            <table class="table table--light">
                <thead>
                    <tr>
                        <th>Subject</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($newTickets as $item)
                    <tr>
                        <td>
                            <a href="{{ route('admin.ticket.view', $item->id) }}">
                                Ticket#{{ $item->ticket }} - {{ strLimit($item->subject,30) }}
                            </a>
                        </td>
                        <td>{!! $item->statusBadge !!}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

    </div>
</div>
<div class="row g-3 mb-4">
    <div class="col-md-8">
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="mb-0">Top Pages (by views)
                        @php
                            $dashboardDataSource = 'none';
                            if(!empty($topPages) && is_array($topPages) && count($topPages) > 0) {
                                $dashboardDataSource = $topPages[0]['source'] ?? 'mixed';
                            }
                        @endphp
                        @if(strtolower($dashboardDataSource) !== 'db_cumulative_fallback')
                            <span class="badge bg-light text-muted ms-2" style="font-size:11px; vertical-align:middle;">Data: {{ strtoupper($dashboardDataSource) }}</span>
                        @endif
                    </h6>
                    <div class="d-flex align-items-center" style="gap:10px;">
                            <small class="text-muted">Showing {{ count($topPages) }} pages</small>
                        </div>
                </div>

                <div class="top-pages-grid">
                    @if(count($topPages) === 0)
                        <div class="text-muted">No data</div>
                    @else
                        @foreach($topPages as $idx => $p)
                        @php
                            $views = (int) ($p['views'] ?? 0);
                            $source = strtoupper($p['source'] ?? 'DB');
                        @endphp
                        <div class="tp-item">
                            <div class="tp-left">
                                <div class="tp-rank">{{ $idx + 1 }}</div>
                                <div class="tp-meta">
                                    <div class="d-flex align-items-center" style="gap:8px;">
                                        <div class="tp-title">
                                            @if(!empty($p['path']))
                                                <a href="{{ $p['path'] }}" target="_blank" rel="noopener">{{ $p['title'] }}</a>
                                            @else
                                                {{ $p['title'] }}
                                            @endif
                                        </div>
                                        @if(strtolower($p['source'] ?? '') !== 'db_cumulative_fallback')
                                            <span class="tp-source badge" title="Data source">{{ $source }}</span>
                                        @endif
                                    </div>

                                    <div class="tp-path">{{ $p['path'] ?? '-' }}</div>

                                    @if(!empty($p['last_viewed_at']))
                                        @php
                                            try {
                                                $lv = \Carbon\Carbon::parse($p['last_viewed_at']);
                                            } catch (\Exception $ex) {
                                                $lv = null;
                                            }
                                        @endphp
                                        @if($lv)
                                            <div class="tp-last text-muted">{{ $lv->diffForHumans() }} <small class="text-muted">&middot; {{ $lv->format('M j, H:i') }}</small></div>
                                        @endif
                                    @endif
                                </div>
                            </div>

                            <div class="tp-right">
                                <div class="tp-views">
                                    <div class="tp-views-count">{{ number_format($views) }}</div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('script')
<script>
// Dashboard range selector: show custom inputs or auto-submit for presets
(function(){
    var range = document.getElementById('dashboard-range');
    var custom = document.querySelector('.custom-dates');
    var form = document.getElementById('dashboard-filter-form');
    if (!range || !form) return;

    // ensure initial visibility matches current selection
    custom.style.display = (range.value === 'custom') ? 'flex' : (custom.style.display || 'none');

    range.addEventListener('change', function(e){
        if (e.target.value === 'custom') {
            // show date inputs and wait for the user to click Apply
            custom.style.display = 'flex';
        } else {
            // hide custom inputs and immediately submit the form for quick filtering
            custom.style.display = 'none';
            // small defer to allow any UI updates before submit
            setTimeout(function(){ form.submit(); }, 10);
        }
    });
})();
</script>
@endpush

@push('style')
<style>
/* Top Pages — redesigned compact ranked list */
.top-pages-grid { display:flex; flex-direction:column; gap:10px; }
.tp-item { display:flex; align-items:center; justify-content:space-between; gap:12px; padding:12px 14px; background:#fff; border-radius:8px; box-shadow:0 6px 18px rgba(14,21,47,0.06); transition:transform .12s ease, box-shadow .12s ease; }
.tp-item:hover { transform:translateY(-4px); box-shadow:0 12px 30px rgba(14,21,47,0.08); }
.tp-left { display:flex; gap:12px; align-items:flex-start; min-width:0; }
.tp-rank { width:40px; height:40px; border-radius:50%; background:#f7fafb; display:flex; align-items:center; justify-content:center; font-weight:700; color:#00a7a7; flex:0 0 40px; box-shadow:0 2px 6px rgba(0,0,0,0.04); }
.tp-meta { display:flex; flex-direction:column; min-width:0; }
.tp-title a { font-weight:600; color: #0b6b67; text-decoration:none; display:inline-block; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; max-width:520px; }
.tp-title a:hover { text-decoration:underline; }
.tp-path { color:#8a9095; font-size:13px; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; }
.tp-last { font-size:12px; color:#6c757d; }
.tp-right { display:flex; flex-direction:column; align-items:center; justify-content:center; gap:6px; min-width:110px; }
.tp-badges .badge { font-size:11px; padding:4px 8px; }
.tp-views { font-weight:800; font-size:16px; color:#fff; background:#00a7a7; padding:6px 12px; border-radius:10px; box-shadow:0 6px 18px rgba(0,167,167,0.12); display:inline-flex; align-items:center; justify-content:center; min-width:56px; }
.tp-right .tp-last { margin-top:4px; font-size:12px; color:#f1f7f6; opacity:0.9; }
.tp-collapsed { display:none; }
.btn--outline { border:1px solid #ced4da; background:transparent; padding:6px 14px; border-radius:6px; }

.tp-source { background: #f1f1f1; color:#1f2933; font-weight:600; font-size:11px; padding:4px 8px; border-radius:999px; }
.tp-views { display:flex; flex-direction:column; align-items:center; justify-content:center; padding:8px 12px; min-width:72px; }
.tp-views-count { font-weight:800; font-size:16px; color:#fff; background:#00a7a7; padding:6px 10px; border-radius:8px; }
/* percentage removed - keep space for future badges if needed */

@media (max-width: 991px) {
  .tp-title a { max-width: 220px; font-size:14px; }
  .tp-right { min-width:60px; }
}
</style>
<!-- removed show-more toggle script: all pages are displayed now -->
@endpush
