@extends('admin.layouts.app')
@section('panel')

<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th>@lang('Date')</th>
                                <th>@lang('Title')</th>
                                <th>@lang('Company Type')</th>
                                <th>@lang('Location')</th>
                                <th>@lang('Urgent')</th>
                                <th>@lang('Prestige')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($rows as $item)
                            <tr>
                                <td>{{ $item->date }}</td>
                                <td>{{ $item->title }}</td>
                                <td>{{ $item->company_type }}</td>
                                <td>{{ $item->location }}</td>
                                <td>
                                    @if ($item->is_urgent)
                                    <span class="badge badge--success">Urgent</span>
                                    @endif
                                </td>
                                <td>
                                    @if ($item->is_internal)
                                    <span class="badge badge--success">TRUE</span>
                                    @endif
                                </td>
                                <td>
                                    @php
                                        echo $item->statusBadge($item->status);
                                    @endphp
                                </td>


                                <td>
                                    <a href="{{route('admin.career.edit',$item->id)}}" title="@lang('Edit')" class="btn btn-sm btn--primary updateService ">
                                        <i class="las la-edit"></i>
                                    </a>
                                    <button title="@lang('Remove')"
                                     data-id="{{$item->id}}"
                                        class="btn btn-sm btn--danger rejectBtn">
                                        <i class="las la-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                            </tr>
                            @endforelse

                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            @if ($rows->hasPages())
            <div class="card-footer py-4">
                {{ paginateLinks($rows) }}
            </div>
            @endif
        </div><!-- card end -->
    </div>
</div>


{{-- delete modal --}}
<div id="rejectModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Delete Career Confirmation')</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="{{route('admin.career.delete')}}" method="POST">
                @csrf
                <input type="hidden" name="id">
                <div class="modal-body">
                    <p>@lang('Are you sure to') <span class="fw-bold">@lang('delete')</span> <span
                            class="fw-bold withdraw-amount text-success"></span> @lang('this career') <span
                            class="fw-bold withdraw-user"></span>?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--danger btn-global">@lang('Delete')</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('breadcrumb-plugins')
<a href="{{route('admin.career.create')}}"  class="btn btn-sm btn--primary">
    @lang('Add Career')</a>
@endpush

@push('script')
<script>
      (function($){
        "use strict";

    $('.rejectBtn').on('click', function () {
            var modal = $('#rejectModal');
            modal.find('input[name=id]').val($(this).data('id'));
            modal.modal('show');
        });

    })(jQuery);
</script>
@endpush

