@extends('admin.layouts.app')
@section('panel')

<div class="row mb-none-30">
    <div class="col-lg-12 mb-30">
        <div class="card">
            <div class="card-body">
                <form action="{{route('admin.career.update',$row->id)}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="date" class="font-weight-bold">@lang('Date')</label>
                                <input name="date" type="text" data-range="false" data-date-format="dd/mm/yyyy"
                                data-language="en" class="datepicker-here form-control" data-position='bottom right'
                                placeholder="@lang('Date')" autocomplete="off" value="{{ old('date') ?? \Carbon\Carbon::parse($row->date)->format('d/m/Y') }}" readonly>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="form-group">
                                <label for="title" class="font-weight-bold">@lang('Title')</label>
                                <input type="text" name="title" id="title" value="{{old('title')??$row->title}}"
                                    class="form-control " placeholder="@lang('Title')"
                                    required>
                            </div>
                        </div>

                        {{-- <div class="col-lg-4">
                            <label for="">Salary Range</label>
                            <div class="input-group">
                                <input type="number" name="salary_range_min" aria-label="Salary Range Min" class="form-control" placeholder="Ex: 100" value="{{ old('salary_range_min')??number_format($row->salary_range_min) }}">
                                <span class="input-group-text">$</span>
                                <input type="number" name="salary_range_max" aria-label="Salary Range Max" class="form-control" placeholder="Ex: 200" value="{{ old('salary_range_max')??number_format($row->salary_range_max) }}">
                                <span class="input-group-text">$</span>
                            </div>
                        </div> --}}

                        <div class="col-lg-4">
                            <label for="">Experience</label>
                            <div class="input-group">
                                <input type="number" name="experience_min" aria-label="Experience Min" class="form-control" placeholder="Ex: 1" value="{{ old('experience_min')??number_format($row->experience_min) }}">
                                <input type="number" name="experience_max" aria-label="Experience Max" class="form-control" placeholder="Ex: 3" value="{{ old('experience_max')??number_format($row->experience_max) }}">
                                <span class="input-group-text">years</span>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="company_type" class="font-weight-bold">@lang('Company Type')</label>
                                <input type="text" name="company_type" id="company_type" value="{{old('company_type')??$row->company_type}}"
                                    class="form-control " placeholder="@lang('Company Type')"
                                    required>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="location" class="font-weight-bold">@lang('Location')</label>
                                <input type="text" name="location" id="location" value="{{old('location')??$row->location}}"
                                    class="form-control" placeholder="@lang('Location')"
                                    required>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="status" class="font-weight-bold">@lang('Status')</label>
                                <select name="status" id="status" class="form-control" required>
                                    <option value="0" {{ $row->status==0 ? 'selected': '' }}>@lang('Inactive')</option>
                                    <option value="1" {{ $row->status==1 ? 'selected': '' }}>@lang('Active')</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="form-group">
                                <label for="apply_url" class="font-weight-bold">@lang('Apply Url')</label>
                                <input type="text" name="apply_url" id="apply_url" value="{{old('apply_url')??$row->apply_url}}"
                                    class="form-control " placeholder="@lang('Apply Url')"
                                    required>
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="type" class="font-weight-bold">@lang('Requirement')</label>
                                <textarea class="trumEdit" name="requirement"
                                placeholder="@lang('Requirement')" id="requirement" cols="40"
                                rows="10">{!! old('requirement')??$row->requirement !!}</textarea>
                            </div>
                        </div>
                        <div class="row text-end">
                            <div class="col-lg-12 ">
                                <div class="form-group float-end p-3">
                                    <button type="submit" class="btn btn--primary btn-block btn-lg"> @lang('Update')</button>
                                </div>
                            </div>
                        </div>
                 </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('breadcrumb-plugins')
<a href="{{route('admin.career.index')}}" class="btn btn-sm btn--primary box--shadow1 text--small"><i
        class="las la-angle-double-left"></i>@lang('Go Back')</a>
@endpush

@push('style-lib')
<link rel="stylesheet" href="{{asset('assets/admin/css/datepicker.min.css')}}">
@endpush

@push('style')
<style>
    .ck-placeholder{
        height: 190px !important;
    }
</style>
@endpush

@push('script-lib')
<script src="{{ asset('assets/admin/js/datepicker.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/datepicker.en.js') }}"></script>
@endpush

@push('script')
<script>
    (function ($) {
        "use strict";
        if (!$('.datepicker-here').val()) {
            $('.datepicker-here').datepicker({
                dateFormat: 'dd/mm/yyyy'
            });
        }
    })(jQuery)
</script>
@endpush


