@extends('admin.layouts.app')
@section('panel')

<div class="row mb-none-30">
    <div class="col-lg-12 mb-30">
        <div class="card">
            <div class="card-body">
                <form id="reportInsideCreateForm" action="{{route('admin.blog.store')}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="form-group">
                                <label for="title" class="font-weight-bold">@lang('Title')</label>
                                <input type="text" name="title" id="title" value="{{old('title')}}"
                                    class="form-control " placeholder="@lang('Title')"
                                    required>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="status" class="font-weight-bold">@lang('Status')</label>
                                <select name="status" id="status" class="form-control " required>
                                    <option value="0">@lang('Inactive')</option>
                                    <option value="1" selected>@lang('Active')</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="image" class="font-weight-bold">@lang('Featured Image')</label>
                                <div class="file-upload-wrapper" data-text="Select your image!">
                                    <input type="file" name="featured_image" id="image" class="file-upload-field" required>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="type" class="font-weight-bold">@lang('Description')</label>
                                <textarea class="trumEdit" name="description"
                                placeholder="@lang('Description')" id="description" cols="40"
                                rows="10"></textarea>
                            </div>
                        </div>
                        <div class="row text-end">
                            <div class="col-lg-12 ">
                                <div class="form-group float-end p-3">
                                    <button type="submit" class="btn btn--primary btn-block btn-lg"> @lang('Create')</button>
                                </div>
                            </div>
                        </div>
                 </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('breadcrumb-plugins')
<a href="{{route('admin.reportinside.index')}}" class="btn btn-sm btn--primary box--shadow1 text--small"><i
        class="las la-angle-double-left"></i>@lang('Go Back')</a>
@endpush


@push('style')
<style>
    .ck-placeholder{
        height: 300px !important;
    }
</style>
@endpush

@push('script')

@endpush