<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('report_downloads', function (Blueprint $table) {
            $table->string('download_report_file')->nullable()->after('email');
            $table->text('download_report_external_url')->nullable()->after('download_report_file');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('report_downloads', function (Blueprint $table) {
            $table->dropColumn(['download_report_file', 'download_report_external_url']);
        });
    }
};
