<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('page_view_logs', function (Blueprint $table) {
            if (!Schema::hasColumn('page_view_logs', 'views')) {
                $table->unsignedBigInteger('views')->default(1)->after('user_agent');
            }
            if (!Schema::hasColumn('page_view_logs', 'view_date')) {
                $table->date('view_date')->nullable()->after('views');
            }
            // add unique index to support upserts by (path, view_date)
            $table->unique(['path','view_date'], 'pvlogs_path_view_date_unique');
        });
    }

    public function down()
    {
        Schema::table('page_view_logs', function (Blueprint $table) {
            $sm = Schema::getConnection()->getDoctrineSchemaManager();
            if (Schema::hasColumn('page_view_logs', 'views')) {
                $table->dropColumn('views');
            }
            if (Schema::hasColumn('page_view_logs', 'view_date')) {
                $table->dropColumn('view_date');
            }
            // drop index if exists
            $table->dropIndex('pvlogs_path_view_date_unique');
        });
    }
};
