<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('page_views', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('path')->index();
            $table->string('title')->nullable();
            $table->unsignedBigInteger('views')->default(0)->index();
            $table->timestamp('last_viewed_at')->nullable()->index();
            $table->timestamps();
            $table->unique(['path']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('page_views');
    }
};
