<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('report_downloads', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('report_id');
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email');
            $table->timestamps();

            // add foreign key only if you're sure the referenced table exists and id type matches:
            $table->foreign('report_id')->references('id')->on('report_and_insides')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('report_downloads');
    }
};
