<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
        'endpoint' => env('MAILGUN_ENDPOINT', 'api.mailgun.net'),
    ],

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'google_analytics' => [
        'enabled' => env('GA_ENABLED', false),
        // Prefer GA4 Measurement ID (starts with G-) but fall back to GA_PROPERTY_ID if present
        'measurement_id' => env('GA_MEASUREMENT_ID', env('GA_PROPERTY_ID', '')),
        // Optional server-side Measurement Protocol secret or service account path
        'api_secret' => env('GA_API_SECRET', ''),
        'service_account_json' => env('GA_SERVICE_ACCOUNT_JSON', ''),
    ],

];
