<?php

namespace App\Providers;

use App\Models\AdminNotification;
use App\Models\Deposit;
use App\Models\Frontend;
use App\Models\Language;
use App\Models\Order;
use App\Models\SupportTicket;
use App\Models\User;
use App\Models\Service;
use App\Models\Portfolio;
use App\Models\ReportDownload;
use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Cache;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {

    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Some helper functions and model calls may rely on DB.
        // Guard these with try/catch so artisan commands or environments
        // without DB access don't cause a hard exception during boot.
        try {
            $general = gs();
            $activeTemplate = activeTemplate();
            $viewShare['general'] = $general;
            $viewShare['activeTemplate'] = $activeTemplate;
            $viewShare['activeTemplateTrue'] = activeTemplate(true);
            $viewShare['language'] = Language::all();
            $viewShare['emptyMessage'] = 'No data';
        } catch (\Exception $e) {
            $viewShare['general'] = null;
            $viewShare['activeTemplate'] = null;
            $viewShare['activeTemplateTrue'] = null;
            $viewShare['language'] = collect();
            $viewShare['emptyMessage'] = 'No data';
        }

        view()->share($viewShare);

        // Share site-wide totals so frontend/user views can display correct counts
        try {
            $siteTotals = [
                'totalUsers' => User::count(),
                'totalServices' => Service::count(),
                'totalPortfolio' => Portfolio::count(),
                'totalDownloads' => ReportDownload::count(),
            ];
            view()->share($siteTotals);
        } catch (\Exception $e) {
            // In case migrations aren't run or tables missing, fail silently
        }

        // Share page view totals (site total and current page) for frontend views
        try {
            if (!app()->runningInConsole() && request()) {
                $isAdmin = request()->is('admin') || request()->is('admin/*');
                if (!$isAdmin) {
                    $totalViews = 0;
                    $currentViews = 0;
                    if (class_exists('\App\\Models\\PageView')) {
                        // Cache the site total briefly to avoid hitting the DB on every request
                        $cacheKey = 'site:page_views_total';
                        $totalViews = Cache::remember($cacheKey, 60, function () {
                            return \App\Models\PageView::where('path', 'not like', 'admin%')
                                ->where('path', 'not like', '/admin%')
                                ->sum('views');
                        });

                        $currentPath = parse_url(request()->getRequestUri(), PHP_URL_PATH) ?: '/';
                        $pv = \App\Models\PageView::where('path', $currentPath)->first();
                        if (!$pv) {
                            $alt = rtrim($currentPath, '/');
                            if ($alt === '') $alt = '/';
                            $pv = \App\Models\PageView::where('path', $alt)->first();
                        }
                        $currentViews = $pv ? (int) $pv->views : 0;
                    }

                    view()->share([
                        'sitePageViewsTotal' => $totalViews,
                        'currentPageViews' => $currentViews,
                    ]);
                }
            }
        } catch (\Exception $e) {
            // swallow
        }
        // Provide counts to several admin UI partials (sidenav and ticket tabs)
        view()->composer([
            'admin.components.sidenav',
            'admin.components.tabs.ticket',
            'admin.components.tabs.user'
        ], function ($view) {
            $view->with([
                'bannedUsersCount'           => User::banned()->count(),
                'emailUnverifiedUsersCount' => User::emailUnverified()->count(),
                'mobileUnverifiedUsersCount'   => User::mobileUnverified()->count(),
                'pendingTicketCount'         => SupportTicket::whereIN('status', [0,2])->count(),
                'pendingDepositsCount'    => Deposit::pending()->count(),

            ]);
        });

        view()->composer('admin.components.topnav', function ($view) {
            $view->with([
                'adminNotifications'=>AdminNotification::where('read_status',0)->with('user')->orderBy('id','desc')->take(10)->get(),
                'adminNotificationCount'=>AdminNotification::where('read_status',0)->count(),
            ]);
        });

        view()->composer('includes.seo', function ($view) {
            $seo = Frontend::where('data_keys', 'seo.data')->first();
            $view->with([
                'seo' => $seo ? $seo->data_values : $seo,
            ]);
        });

        if($general->force_ssl){
            \URL::forceScheme('https');
        }


        Paginator::useBootstrapFour();
    }
}
