<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReportDownload extends Model
{
    use HasFactory;

    // Snapshot the report file/url at time of download so historical records don't change
    protected $fillable = [
        'report_id',
        'first_name',
        'last_name',
        'email',
        'download_report_file',
        'download_report_external_url',
    ];

    public function report()
    {
        return $this->belongsTo(ReportAndInside::class, 'report_id');
    }
}
