<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReportAndInside extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'title',
        'slug',
        'image',
        'description',
        'download_report_file',
        'download_report_external_url',
        'status',
        'view_count'
    ];

    public function statusBadge($status){
        $html = '';
        if($this->status == 1) {
            $html = '<span class="badge badge--success">'.trans('Active').'</span>';
        }else{
            $html = '<span class="badge badge--warning">'.trans('Inactive').'</span>';
        }

        return $html;
    }

    public function category()
    {
        return $this->belongsTo(ReportAndInsideCategory::class, 'category_id');
    }
}
