<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OfficeEventSpaceSlide extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'image',
        'status'
    ];

    public function statusBadge($status){
        $html = '';
        if($this->status == 1) {
            $html = '<span class="badge badge--success">'.trans('Active').'</span>';
        }else{
            $html = '<span class="badge badge--warning">'.trans('Inactive').'</span>';
        }

        return $html;
    }
}
